/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.network;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.ui.network.NetVis;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Collection;
import javax.swing.BorderFactory;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.controls.Control;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.NeighborHighlightControl;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkThumbnail
extends Display {
    private static final long serialVersionUID = -3609205303178349548L;
    public static final String DRAW = "draw";
    private int size = 150;

    public NetworkThumbnail(Visualization vis) {
        super(vis);
        this.setHighQuality(true);
        this.setBorder(BorderFactory.createLineBorder(Color.RED));
        this.setSize(this.size, this.size);
        this.pan(350.0, 350.0);
        this.setForeground(Color.GRAY);
        this.setBackground(Color.WHITE);
        this.addControlListener((Control)new FocusControl(1));
        this.addControlListener((Control)new DragControl());
        this.addControlListener((Control)new PanControl());
        this.addControlListener((Control)new ZoomControl());
        this.addControlListener((Control)new WheelZoomControl());
        this.addControlListener((Control)new ZoomToFitControl());
        this.addControlListener((Control)new NeighborHighlightControl());
        this.m_vis.run("layout");
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public void setData(Clustering c, Collection<Vertex> pair) {
        if (this.m_vis instanceof NetVis) {
            NetVis vis = (NetVis)this.m_vis;
            vis.setClustering(c);
            vis.setSelectedVertexPair(pair);
            vis.run(DRAW);
        }
    }
}

