/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.network;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Vertex;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.DataColorAction;
import prefuse.action.layout.Layout;
import prefuse.action.layout.graph.ForceDirectedLayout;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Edge;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.Predicate;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.PolygonRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.render.ShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.GraphicsLib;
import prefuse.util.PrefuseLib;
import prefuse.visual.AggregateItem;
import prefuse.visual.AggregateTable;
import prefuse.visual.DecoratorItem;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.HoverPredicate;
import prefuse.visual.expression.InGroupPredicate;
import prefuse.visual.expression.VisiblePredicate;

public class GraphView
extends Display
implements PropertyChangeListener {
    private static final long serialVersionUID = 2968574637464096058L;
    private static final Schema DECORATOR_SCHEMA = PrefuseLib.getVisualItemSchema();
    public static final String GRAPH = "graph";
    public static final String NODES = "graph.nodes";
    public static final String EDGES = "graph.edges";
    public static final String AGGR = "aggregates";
    public static final String NODE_DECORATORS = "nodeDeco";
    public static final String AGGR_DECORATORS = "aggrDeco";
    public static final String DRAW = "draw";
    public static final String LAYOUT = "layout";
    public static final String FOCUS = "focus";
    public static final String CLUSTER = "cluster";
    public static final String FILTER = "filter";
    public static final String ADJUST = "adjust";
    private Graph graph;
    private AggregateTable aggregateTable;
    private int[] palette;
    private DataModel _dataModel;
    private Clustering clustering;

    static {
        DECORATOR_SCHEMA.setDefault(VisualItem.INTERACTIVE, false);
        DECORATOR_SCHEMA.setDefault(VisualItem.TEXTCOLOR, ColorLib.gray((int)225));
        DECORATOR_SCHEMA.setDefault(VisualItem.FONT, (Object)FontLib.getFont((String)"Tahoma", (double)14.0));
    }

    public GraphView(DataModel model) {
        super(new Visualization());
        this._dataModel = model;
        if (model != null) {
            model.addPropertyChangeListener("networkLoaded", this);
            model.addPropertyChangeListener("currentMatrixChanged", this);
            model.addPropertyChangeListener("selectedVerticesChanged", this);
            model.addPropertyChangeListener("boundryWeightChanged", this);
            model.addPropertyChangeListener("internalChanged", this);
        }
    }

    private void initializeGraphView() {
        System.out.println("Initializing prefuse netVis");
        this.graph = this.buildGraph(this._dataModel);
        this.m_vis.addGraph(GRAPH, this.graph);
        this.m_vis.setInteractive(EDGES, null, false);
        this.m_vis.setValue(NODES, null, VisualItem.SHAPE, (Object)new Integer(1));
        this.aggregateTable = this.m_vis.addAggregates(AGGR);
        this.aggregateTable.addColumn("name", String.class);
        this.aggregateTable.addColumn("id", Integer.TYPE);
        this.aggregateTable.addColumn(VisualItem.POLYGON, double[].class);
        ShapeRenderer nodeRenderer = new ShapeRenderer(20);
        PolygonRenderer polygonRenderer = new PolygonRenderer(1);
        polygonRenderer.setCurveSlack(0.15f);
        DefaultRendererFactory rendererFactory = new DefaultRendererFactory();
        rendererFactory.setDefaultRenderer((Renderer)nodeRenderer);
        rendererFactory.add("ingroup('aggregates')", (Renderer)polygonRenderer);
        rendererFactory.add((Predicate)new InGroupPredicate(NODE_DECORATORS), (Renderer)new LabelRenderer("name"));
        rendererFactory.add((Predicate)new InGroupPredicate(AGGR_DECORATORS), (Renderer)new LabelRenderer("name"));
        this.m_vis.setRendererFactory((RendererFactory)rendererFactory);
        DECORATOR_SCHEMA.setDefault(VisualItem.TEXTCOLOR, ColorLib.gray((int)50));
        this.m_vis.addDecorators(NODE_DECORATORS, NODES, (Predicate)new VisiblePredicate(), DECORATOR_SCHEMA);
        DECORATOR_SCHEMA.setDefault(VisualItem.TEXTCOLOR, ColorLib.gray((int)0, (int)128));
        this.m_vis.addDecorators(AGGR_DECORATORS, AGGR, (Predicate)new HoverPredicate(), DECORATOR_SCHEMA);
        TupleSet focusGroup = this.m_vis.getGroup(Visualization.FOCUS_ITEMS);
        focusGroup.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet ts, Tuple[] add, Tuple[] rem) {
                int i = 0;
                while (i < rem.length) {
                    ((VisualItem)rem[i]).setFixed(false);
                    ++i;
                }
                i = 0;
                while (i < add.length) {
                    ((VisualItem)add[i]).setFixed(false);
                    ((VisualItem)add[i]).setFixed(true);
                    ++i;
                }
                if (ts.getTupleCount() == 0) {
                    ts.addTuple(rem[0]);
                    ((VisualItem)rem[0]).setFixed(false);
                }
                GraphView.this.m_vis.run(GraphView.DRAW);
            }
        });
        TupleSet aggregates = this.m_vis.getGroup(AGGR);
        aggregates.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet ts, Tuple[] add, Tuple[] rem) {
                GraphView.this.m_vis.run(GraphView.DRAW);
            }
        });
        ForceDirectedLayout layout = new ForceDirectedLayout(GRAPH, true);
        ColorAction nStroke = new ColorAction(NODES, VisualItem.STROKECOLOR);
        nStroke.setDefaultColor(ColorLib.gray((int)50));
        ColorAction nFill = new ColorAction(NODES, VisualItem.FILLCOLOR);
        nFill.setDefaultColor(ColorLib.gray((int)255));
        ColorAction fFill = new ColorAction(Visualization.FOCUS_ITEMS, VisualItem.FILLCOLOR);
        fFill.setDefaultColor(ColorLib.gray((int)200));
        ColorAction nEdges = new ColorAction(EDGES, VisualItem.STROKECOLOR);
        nEdges.setDefaultColor(ColorLib.gray((int)50));
        ColorAction aStroke = new ColorAction(AGGR, VisualItem.STROKECOLOR);
        aStroke.setDefaultColor(ColorLib.gray((int)200));
        DataColorAction aFill = new DataColorAction(AGGR, "id", 0, VisualItem.FILLCOLOR, this.palette);
        ActionList colors = new ActionList();
        colors.add((Action)nStroke);
        colors.add((Action)nFill);
        colors.add((Action)fFill);
        colors.add((Action)nEdges);
        colors.add((Action)aFill);
        ActionList draw = new ActionList();
        draw.add((Action)colors);
        ActionList animate = new ActionList(-1L);
        animate.add((Action)layout);
        animate.add((Action)new AggregateLayout(AGGR));
        animate.add((Action)new LabelLayout(NODE_DECORATORS));
        animate.add((Action)new LabelLayout(AGGR_DECORATORS));
        animate.add((Action)new RepaintAction());
        this.m_vis.putAction(DRAW, (Action)draw);
        this.m_vis.putAction(LAYOUT, (Action)animate);
        this.m_vis.putAction(FOCUS, new Action(){

            public void run(double frac) {
                this.m_vis.getGroup(Visualization.FOCUS_ITEMS).clear();
                GraphView.this._dataModel.getSelectedVertices();
            }
        });
        this.m_vis.putAction(CLUSTER, new Action(){

            public void run(double frac) {
                GraphView.this.setAggregates(GraphView.this._dataModel);
            }
        });
        this.m_vis.runAfter(DRAW, LAYOUT);
        this.setSize(450, 250);
        this.pan(250.0, 250.0);
        this.setHighQuality(true);
        this.addControlListener((Control)new AggregateDragControl());
        this.addControlListener((Control)new PanControl());
        this.addControlListener((Control)new ZoomControl());
        this.addControlListener((Control)new WheelZoomControl());
        this.addControlListener((Control)new ZoomToFitControl());
        this.m_vis.run(DRAW);
    }

    private Graph buildGraph(DataModel model) {
        Graph graph = new Graph();
        graph.getNodes().addColumn("name", String.class);
        graph.getEdges().addColumn("weight", Double.TYPE);
        Map<String, Vertex> map = model.getVertices();
        if (map == null) {
            return graph;
        }
        Vertex[] vertices = new Vertex[map.size()];
        Collection<Vertex> vertexColl = map.values();
        Iterator<Vertex> iterator = vertexColl.iterator();
        while (iterator.hasNext()) {
            Vertex v;
            vertices[v.getIndex()] = v = iterator.next();
        }
        int i = 0;
        while (i < vertices.length) {
            Node n = graph.addNode();
            n.setString("name", vertices[i].getName());
            ++i;
        }
        Vertex[] vertexArray = vertices;
        int n = vertices.length;
        int n2 = 0;
        while (n2 < n) {
            Vertex v = vertexArray[n2];
            for (Vertex u : v.getNeighbors()) {
                Edge e = graph.addEdge(graph.getNode(v.getIndex()), graph.getNode(u.getIndex()));
                if (!model.isWeighted()) continue;
                e.setDouble("weight", v.getEdgeWeight(u));
            }
            ++n2;
        }
        return graph;
    }

    private void setAggregates(DataModel model) {
        this.m_vis.getGroup(AGGR).clear();
        if (this.clustering != null) {
            model.getSelectedVertices();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("networkLoaded")) {
            this.initializeGraphView();
        } else if (name.equals("selectedVerticesChanged")) {
            this.m_vis.run(FOCUS);
        } else if (name.equals("selectedClusteringChanged")) {
            this.m_vis.run(CLUSTER);
        } else if (name.equals("boundryWeightChanged") || name.equals("internalChanged")) {
            this.m_vis.run(ADJUST);
        }
    }

    public void setClustering(Clustering c) {
        this.clustering = c;
    }

    class AggregateDragControl
    extends ControlAdapter {
        private VisualItem activeItem;
        protected Point2D down = new Point2D.Double();
        protected Point2D temp = new Point2D.Double();
        protected boolean dragged;

        public void itemEntered(VisualItem item, MouseEvent e) {
            Display d = (Display)e.getSource();
            d.setCursor(Cursor.getPredefinedCursor(12));
            this.activeItem = item;
            if (!(item instanceof AggregateItem)) {
                this.setFixed(item, true);
            }
        }

        public void itemExited(VisualItem item, MouseEvent e) {
            if (this.activeItem == item) {
                this.activeItem = null;
                this.setFixed(item, false);
            }
            Display d = (Display)e.getSource();
            d.setCursor(Cursor.getDefaultCursor());
        }

        public void itemPressed(VisualItem item, MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this.dragged = false;
            Display d = (Display)e.getComponent();
            d.getAbsoluteCoordinate((Point2D)e.getPoint(), this.down);
            if (item instanceof AggregateItem) {
                this.setFixed(item, true);
            }
        }

        public void itemReleased(VisualItem item, MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (this.dragged) {
                this.activeItem = null;
                this.setFixed(item, false);
                this.dragged = false;
            }
        }

        public void itemDragged(VisualItem item, MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this.dragged = true;
            Display d = (Display)e.getComponent();
            d.getAbsoluteCoordinate((Point2D)e.getPoint(), this.temp);
            double dx = this.temp.getX() - this.down.getX();
            double dy = this.temp.getY() - this.down.getY();
            this.move(item, dx, dy);
            this.down.setLocation(this.temp);
        }

        protected void setFixed(VisualItem item, boolean fixed) {
            if (item instanceof AggregateItem) {
                Iterator items = ((AggregateItem)item).items();
                while (items.hasNext()) {
                    this.setFixed((VisualItem)items.next(), fixed);
                }
            } else if (!GraphView.this.m_vis.getGroup(Visualization.FOCUS_ITEMS).containsTuple((Tuple)item)) {
                item.setFixed(fixed);
            }
        }

        protected void move(VisualItem item, double dx, double dy) {
            if (item instanceof AggregateItem) {
                Iterator items = ((AggregateItem)item).items();
                while (items.hasNext()) {
                    this.move((VisualItem)items.next(), dx, dy);
                }
            } else {
                double x = item.getX();
                double y = item.getY();
                item.setStartX(x);
                item.setStartY(y);
                item.setX(x + dx);
                item.setY(y + dy);
                item.setEndX(x + dx);
                item.setEndY(y + dy);
            }
        }
    }

    class AggregateLayout
    extends Layout {
        private int m_margin;
        private double[] m_pts;

        public AggregateLayout(String aggrGroup) {
            super(aggrGroup);
            this.m_margin = 5;
        }

        public void run(double frac) {
            AggregateTable aggr = (AggregateTable)this.m_vis.getGroup(this.m_group);
            int num = aggr.getTupleCount();
            if (num == 0) {
                return;
            }
            int maxsz = 0;
            Iterator aggrs = aggr.tuples();
            while (aggrs.hasNext()) {
                maxsz = Math.max(maxsz, 8 * ((AggregateItem)aggrs.next()).getAggregateSize());
            }
            if (this.m_pts == null || maxsz > this.m_pts.length) {
                this.m_pts = new double[maxsz];
            }
            aggrs = this.m_vis.visibleItems(this.m_group);
            while (aggrs.hasNext()) {
                AggregateItem aitem = (AggregateItem)aggrs.next();
                int idx = 0;
                if (aitem.getAggregateSize() == 0) continue;
                VisualItem item = null;
                Iterator iter = aitem.items();
                while (iter.hasNext()) {
                    item = (VisualItem)iter.next();
                    if (!item.isVisible()) continue;
                    this.addPoint(this.m_pts, idx, item, this.m_margin);
                    idx += 8;
                }
                if (idx == 0) {
                    aitem.set(VisualItem.POLYGON, null);
                    continue;
                }
                double[] nhull = GraphicsLib.convexHull((double[])this.m_pts, (int)idx);
                double[] fhull = (double[])aitem.get(VisualItem.POLYGON);
                if (fhull == null || fhull.length < nhull.length) {
                    fhull = new double[nhull.length];
                } else if (fhull.length > nhull.length) {
                    fhull[nhull.length] = Double.NaN;
                }
                int j = 0;
                while (j < nhull.length) {
                    fhull[j] = nhull[j];
                    ++j;
                }
                aitem.set(VisualItem.POLYGON, (Object)fhull);
                aitem.setValidated(false);
            }
        }

        private void addPoint(double[] pts, int idx, VisualItem item, int growth) {
            Rectangle2D b = item.getBounds();
            double minX = b.getMinX() - (double)growth;
            double minY = b.getMinY() - (double)growth;
            double maxX = b.getMaxX() + (double)growth;
            double maxY = b.getMaxY() + (double)growth;
            pts[idx] = minX;
            pts[idx + 1] = minY;
            pts[idx + 2] = minX;
            pts[idx + 3] = maxY;
            pts[idx + 4] = maxX;
            pts[idx + 5] = minY;
            pts[idx + 6] = maxX;
            pts[idx + 7] = maxY;
        }
    }

    class LabelLayout
    extends Layout {
        public LabelLayout(String group) {
            super(group);
        }

        public void run(double frac) {
            Iterator iter = this.m_vis.items(this.m_group);
            while (iter.hasNext()) {
                DecoratorItem decorator = (DecoratorItem)iter.next();
                VisualItem decoratedItem = decorator.getDecoratedItem();
                Rectangle2D bounds = decoratedItem.getBounds();
                double x = bounds.getCenterX();
                double y = bounds.getCenterY();
                this.setX((VisualItem)decorator, null, x);
                this.setY((VisualItem)decorator, null, y);
            }
        }
    }
}

