/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.network;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.ui.network.ListDataItem;
import edu.umd.coral.ui.network.NetVis;
import edu.umd.coral.ui.network.NetworkThumbnail;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ClusteringThumb
extends JPanel
implements ListCellRenderer {
    private static final long serialVersionUID = -8566269207121602796L;
    private JLabel clusteringName;
    private NetworkThumbnail graphView;

    public ClusteringThumb() {
        this.setLayout(new BoxLayout(this, 1));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        this.setBackground(Color.WHITE);
        this.clusteringName = new JLabel();
        this.clusteringName.setAlignmentX(0.5f);
        this.add(this.clusteringName);
        this.graphView = new NetworkThumbnail(new NetVis());
        this.graphView.setAlignmentX(0.5f);
        this.add((Component)((Object)this.graphView));
    }

    public Component getListCellRendererComponent(JList list, Object data, int index, boolean isSelected, boolean hasFocus) {
        ListDataItem item = (ListDataItem)data;
        Clustering c = item.getClustering();
        this.clusteringName.setText(c.getName());
        this.graphView.setData(c, item.getSelectedPair());
        return this;
    }
}

