/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.ladder;

import edu.umd.coral.model.data.Named;
import edu.umd.coral.model.data.Score;
import edu.umd.coral.ui.IDataRenderer;
import edu.umd.coral.ui.IHighlightable;
import edu.umd.coral.ui.ISelectable;
import edu.umd.coral.ui.ladder.Cell;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractiveCell<T, C extends Named>
extends Cell
implements ISelectable,
IHighlightable,
IDataRenderer<T>,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -3335015641146449912L;
    private boolean selected = false;
    private boolean highlighted = false;
    private T value;
    private C left;
    private C right;
    private static final int DELAY = 0;

    public InteractiveCell(int width, int height) {
        super(width, height);
        this.setPreferredSize(new Dimension(width, height));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.getCellWidth(), this.getCellHeight());
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        if (selected == this.selected) {
            return;
        }
        this.selected = selected;
        this.repaint();
        this.firePropertyChange("cellSelectedChanged", !selected, selected);
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        if (highlighted == this.highlighted) {
            return;
        }
        this.highlighted = highlighted;
        this.repaint(0L);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        if (this.getValue() == null) {
            return;
        }
        g2.clearRect(0, 0, this.getCellWidth(), this.getCellHeight());
        Color c = this.getColor();
        if (this.getColor() == null) {
            c = Color.RED;
        }
        g2.setColor(c);
        g.fillRect(1, 1, this.getCellWidth() - 1, this.getCellHeight() - 1);
        if (this.highlighted) {
            g2.setColor(Color.YELLOW);
        } else if (this.selected) {
            g2.setColor(Color.RED);
        }
        g2.setStroke(new BasicStroke(4.0f));
        if (this.selected || this.highlighted) {
            g2.drawRect(0, 0, this.getCellWidth(), this.getCellHeight());
        }
        String v = new DecimalFormat("#0.00").format(this.value);
        FontMetrics fm = g2.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(v, g2);
        g2.setColor(Color.BLACK);
        if ((double)this.getCellWidth() > bounds.getWidth() + 2.0 && (double)this.getCellHeight() > bounds.getHeight() + 2.0) {
            g.drawString(String.valueOf(v), (int)((double)this.getCellWidth() - bounds.getWidth()) / 2, (int)((double)this.getCellWidth() + bounds.getHeight() - 2.0) / 2);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        this.setSelected(!this.selected);
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.setHighlighted(true);
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.setHighlighted(false);
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T v) {
        this.value = v;
    }

    public void setPair(C c1, C c2) {
        this.left = c1;
        this.right = c2;
    }

    public C getLeft() {
        return this.left;
    }

    public C getRight() {
        return this.right;
    }

    public Score<C> getScore() {
        return new Score<C>(this.left, this.right, 0.0f);
    }
}

