/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.ladder;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;

public class Cell
extends JComponent {
    private static final long serialVersionUID = -3335015641146449912L;
    private int cellWidth;
    private int cellHeight;
    private boolean drawBorder = false;
    private Color color;

    public Cell(int width, int height) {
        this.cellWidth = width;
        this.cellHeight = height;
        this.setPreferredSize(new Dimension(width, height));
        if (this.drawBorder) {
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        }
        ToolTipManager.sharedInstance().setInitialDelay(0);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.cellWidth, this.cellHeight);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
        if (drawBorder) {
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        } else {
            this.setBorder(null);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color c = this.color == null ? Color.GRAY : this.color;
        g.setColor(c);
        Dimension size = this.getSize();
        int x = (size.width - this.cellWidth) / 2;
        int y = (size.height - this.cellHeight) / 2;
        g.fillRect(x + 1, y + 1, this.cellWidth - 1, this.cellHeight - 1);
    }

    public int getCellWidth() {
        return this.cellWidth;
    }

    public void setCellWidth(int cellWidth) {
        this.cellWidth = cellWidth;
        this.repaint();
    }

    public int getCellHeight() {
        return this.cellHeight;
    }

    public void setCellHeight(int cellHeight) {
        this.cellHeight = cellHeight;
        this.repaint();
    }
}

