/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.ladder;

import edu.umd.coral.model.GradientColorModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.ComparisonScores;
import edu.umd.coral.model.data.Score;
import edu.umd.coral.ui.ladder.InteractiveCell;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class All2AllTable
extends JPanel
implements PropertyChangeListener,
ComponentListener {
    private static final long serialVersionUID = -2628664877354239849L;
    private ComparisonScores<Clustering> comparisonItems;
    private int cellSize = 20;
    private InteractiveCell<Float, Clustering> selectedCell = null;
    private InteractiveCell<Float, Clustering>[] cells;
    private final float minValue = 0.0f;
    private float maxValue;
    private int minFontSize = 6;
    private int fontHeight = 0;

    public All2AllTable() {
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(null);
        this.addComponentListener(this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.comparisonItems == null) {
            g.drawString("Load data", 10, 20);
            return;
        }
        if (this.cellSize - 1 >= this.minFontSize) {
            g.setColor(Color.BLACK);
            int labelX = 3;
            int labelY = this.fontHeight - 3;
            int i = 0;
            while (i < this.comparisonItems.getSize()) {
                String item = this.comparisonItems.getXItem(i).getName();
                g.drawString(item, labelX + 2, labelY - 2);
                labelX += this.cellSize;
                labelY += this.cellSize;
                ++i;
            }
        }
    }

    private void updateCells() {
        this.removeCells();
        this.addCells(this.comparisonItems);
    }

    private void addCells(ComparisonScores<Clustering> comparisonItems) {
        if (comparisonItems == null) {
            return;
        }
        int size = comparisonItems.getSize();
        this.cells = new InteractiveCell[size * (size - 1) / 2];
        float diff = this.maxValue - 0.0f;
        if (diff == 0.0f) {
            diff = 1.0f;
        }
        if (comparisonItems.getSize() == 0) {
            return;
        }
        int k = 0;
        int i = 0;
        while (i < size) {
            String l1 = comparisonItems.getXItem(i).getName();
            int index1 = comparisonItems.getIndex(l1);
            int j = i + 1;
            while (j < size) {
                String l2 = comparisonItems.getXItem(j).getName();
                int index2 = comparisonItems.getIndex(l2);
                float value = comparisonItems.getValue(index1, index2);
                InteractiveCell<Float, Clustering> cell = new InteractiveCell<Float, Clustering>(this.cellSize, this.cellSize);
                Color cellColor = GradientColorModel.getLadderColor((value - 0.0f) / diff, 1.0f, false);
                cell.setValue(Float.valueOf(value));
                cell.setColor(cellColor);
                cell.setToolTipText(String.valueOf(l1) + ", " + l2 + ": " + String.valueOf(value));
                cell.setPair(comparisonItems.getXItem(index1), comparisonItems.getXItem(index2));
                cell.setBounds(0 + i * this.cellSize, 0 + (j - 1) * this.cellSize + this.fontHeight, this.cellSize, this.cellSize);
                cell.addPropertyChangeListener("cellSelectedChanged", this);
                this.add(cell);
                this.cells[k++] = cell;
                ++j;
            }
            ++i;
        }
    }

    private void removeCells() {
        if (this.cells != null) {
            InteractiveCell<Float, Clustering>[] interactiveCellArray = this.cells;
            int n = this.cells.length;
            int n2 = 0;
            while (n2 < n) {
                InteractiveCell<Float, Clustering> c = interactiveCellArray[n2];
                this.remove(c);
                Object var1_4 = null;
                ++n2;
            }
        }
        this.cells = null;
    }

    public void setComparisonItems(ComparisonScores<Clustering> clusteringScores) {
        this.comparisonItems = clusteringScores;
        if (this.comparisonItems == null) {
            this.maxValue = 0.0f;
            this.updateCells();
            return;
        }
        this.maxValue = this.comparisonItems.getMax();
        this.updateCellSize(this);
        this.updateCells();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                All2AllTable.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        JFrame f = new JFrame("Swing Paint Demo");
        f.setDefaultCloseOperation(3);
        All2AllTable panel = new All2AllTable();
        panel.setPreferredSize(new Dimension(200, 200));
        String[] items = new String[]{"c1", "c2", "c3", "c4", "c5", "c6", "c7", "c8"};
        f.add(panel);
        f.pack();
        f.setVisible(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("cellSelectedChanged")) {
            Score<Clustering> newValue;
            Score<Clustering> oldValue;
            boolean newSelectedValue = (Boolean)evt.getNewValue();
            if (this.selectedCell != null) {
                if (newSelectedValue) {
                    oldValue = this.selectedCell.getScore();
                    this.selectedCell.setSelected(false);
                    this.selectedCell = (InteractiveCell)evt.getSource();
                    newValue = this.selectedCell.getScore();
                } else {
                    oldValue = this.selectedCell.getScore();
                    newValue = null;
                    this.selectedCell = null;
                }
            } else {
                oldValue = null;
                this.selectedCell = (InteractiveCell)evt.getSource();
                newValue = this.selectedCell.getScore();
            }
            this.firePropertyChange("cellSelectedChanged", oldValue, newValue);
        }
        this.repaint();
    }

    private void updateCellSize(Component c) {
        Dimension d = c.getSize();
        if (this.comparisonItems == null) {
            return;
        }
        Graphics g = this.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds("laA1234567890", g);
        this.fontHeight = (int)Math.floor(bounds.getHeight());
        int cellCount = this.comparisonItems.getSize();
        int h = d.height;
        this.cellSize = cellCount == 1 ? h - this.fontHeight : (int)Math.floor((h - this.fontHeight) / (cellCount - 1));
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateCellSize((Component)e.getSource());
        this.updateCells();
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }
}

