/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.dialog;

import edu.umd.coral.model.DataModel;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectColumnsDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 5381034022442137695L;
    private DataModel model;
    String tableName;
    ArrayList<String> selectedColumns;
    ArrayList<JCheckBox> checkboxes = new ArrayList();
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;

    public SelectColumnsDialog(DataModel model, ArrayList<String> columns, String tableName) {
        this.model = model;
        this.tableName = tableName;
        this.selectedColumns = this.getColumnNames(tableName);
        this.initComponents(columns);
    }

    private ArrayList<String> getColumnNames(String tableName) {
        if (tableName.equals("v2vTable")) {
            return this.model.getVertexTableColumns();
        }
        if (tableName.equals("c2cTable")) {
            return this.model.getModuleTableColumns();
        }
        return new ArrayList<String>();
    }

    private void setColumnNames(String tableName, ArrayList<String> names) {
        if (tableName.equals("v2vTable")) {
            this.model.setVertexTableColumns(names);
        } else if (tableName.equals("c2cTable")) {
            this.model.setModuleTableColumns(names);
        }
    }

    private void initComponents(ArrayList<String> columns) {
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        for (String s : columns) {
            JCheckBox checkbox = new JCheckBox();
            checkbox.setText(s);
            if (this.selectedColumns.contains(s)) {
                checkbox.setSelected(true);
            }
            checkbox.addActionListener(this);
            this.checkboxes.add(checkbox);
        }
        this.setDefaultCloseOperation(0);
        this.jLabel1.setText("Select columns to show in a table:");
        this.jButton1.setText("Show");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectColumnsDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectColumnsDialog.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(this.createInsideParalleGroup(layout)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(this.createSequentialGroup(layout)));
        this.pack();
    }

    private GroupLayout.Group createSequentialGroup(GroupLayout layout) {
        GroupLayout.SequentialGroup sg = layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1);
        for (JCheckBox c : this.checkboxes) {
            sg.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(c);
        }
        sg.addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addContainerGap(-1, Short.MAX_VALUE);
        return sg;
    }

    private GroupLayout.ParallelGroup createInsideParalleGroup(GroupLayout layout) {
        GroupLayout.ParallelGroup pg = layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1);
        for (JCheckBox c : this.checkboxes) {
            pg.addComponent(c);
        }
        pg.addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jButton2).addGap(18, 18, 18).addComponent(this.jButton1));
        return pg;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setColumnNames(this.tableName, this.selectedColumns);
        this.close();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.close();
    }

    private void close() {
        super.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SelectColumnsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SelectColumnsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SelectColumnsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SelectColumnsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ArrayList<String> list = new ArrayList<String>();
                list.add("a");
                list.add("b");
                list.add("c");
                list.add("d");
                list.add("e");
                list.add("f");
                new SelectColumnsDialog(null, list, "").setVisible(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JCheckBox) {
            JCheckBox check = (JCheckBox)evt.getSource();
            if (check.isSelected()) {
                this.selectedColumns.add(check.getText());
            } else {
                this.selectedColumns.remove(check.getText());
            }
        }
    }
}

