/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.dialog;

import edu.umd.coral.managers.MatrixManager;
import edu.umd.coral.model.DataModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SaveMatrixDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -7901140272876185495L;
    public static final String ADJ_LIST = "adjacency list";
    public static final String MATRIX = "matrix";
    public static final String DEFAULT_PATH = ".";
    public static final String[] SEPARATORS = new String[]{"\\t", ",", ";", "\\s"};
    private static final String SAVE = "Save";
    private static final String CANCEL = "Cancel";
    private static final String BROWSE = "Browse...";
    private boolean saveAsMatrix = true;
    private String separator = ";";
    private File directory = new File(".");
    private DataModel _dataModel;
    private JTextField tf;

    public SaveMatrixDialog(DataModel model, int x, int y) {
        this._dataModel = model;
        this.setLocation(x, y);
        this.setDefaultCloseOperation(2);
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel options = new JPanel();
        options.setAlignmentX(0.0f);
        options.setLayout(new BoxLayout(options, 1));
        JPanel p1 = new JPanel();
        p1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Save as:"), BorderFactory.createEmptyBorder()));
        p1.setAlignmentY(0.0f);
        ButtonGroup group = new ButtonGroup();
        JRadioButton rb = new JRadioButton(ADJ_LIST);
        rb.setAlignmentX(0.0f);
        rb.setSelected(!this.saveAsMatrix);
        rb.setActionCommand(ADJ_LIST);
        rb.addActionListener(this);
        p1.add(rb);
        group.add(rb);
        rb = new JRadioButton(MATRIX);
        rb.setAlignmentX(0.0f);
        rb.setSelected(this.saveAsMatrix);
        rb.setActionCommand(MATRIX);
        rb.addActionListener(this);
        p1.add(rb);
        group.add(rb);
        options.add(p1);
        p1 = new JPanel();
        p1.setBorder(BorderFactory.createTitledBorder("Separator:"));
        p1.setAlignmentY(0.0f);
        JComboBox<String> combo = new JComboBox<String>(SEPARATORS);
        combo.setSelectedItem(this.separator);
        combo.addActionListener(this);
        p1.add(combo);
        options.add(p1);
        this.add(options);
        options = new JPanel();
        options.setAlignmentX(0.0f);
        options.setLayout(new BoxLayout(options, 1));
        JLabel l = new JLabel("Save to:");
        l.setAlignmentX(0.0f);
        options.add(l);
        p1 = new JPanel();
        p1.setAlignmentX(0.0f);
        p1.setLayout(new BoxLayout(p1, 0));
        this.tf = new JTextField(20);
        this.tf.setText(DEFAULT_PATH);
        p1.add(this.tf);
        JButton btn = new JButton(BROWSE);
        btn.addActionListener(this);
        p1.add(btn);
        options.add(p1);
        this.add(options);
        options = new JPanel();
        options.setAlignmentX(0.0f);
        options.setLayout(new BoxLayout(options, 0));
        options.add(Box.createHorizontalGlue());
        btn = new JButton(SAVE);
        btn.addActionListener(this);
        options.add(btn);
        btn = new JButton(CANCEL);
        btn.addActionListener(this);
        options.add(btn);
        this.add(options);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JRadioButton) {
            JRadioButton button = (JRadioButton)source;
            String text = button.getText();
            if (text.equals(MATRIX)) {
                this.saveAsMatrix = true;
            } else if (text.equals(ADJ_LIST)) {
                this.saveAsMatrix = false;
            }
        } else if (source instanceof JComboBox) {
            JComboBox combo = (JComboBox)source;
            this.separator = (String)combo.getSelectedItem();
        } else if (source instanceof JButton) {
            JButton btn = (JButton)source;
            String text = btn.getText();
            if (text.contains(BROWSE)) {
                this.openFileBrowser();
            } else if (text.contains(SAVE)) {
                this.save();
            } else {
                this.close();
            }
        }
    }

    private void openFileBrowser() {
        File f = new File("temp.tmp");
        String path = null;
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JFileChooser fc = new JFileChooser(path);
        fc.setMultiSelectionEnabled(true);
        fc.setFileSelectionMode(1);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            this.directory = fc.getSelectedFile();
            try {
                this.tf.setText(this.directory.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void save() {
        MatrixManager m = this.saveAsMatrix ? new MatrixManager(this._dataModel, this.directory, this.separator, 1) : new MatrixManager(this._dataModel, this.directory, this.separator, 2);
        m.execute();
        this.close();
    }

    private void close() {
        super.setVisible(false);
        this.dispose();
    }

    private static void createAndShowGUI() {
        SaveMatrixDialog dialog = new SaveMatrixDialog(null, 100, 100);
        dialog.pack();
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SaveMatrixDialog.createAndShowGUI();
            }
        });
    }
}

