/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.dialog;

import edu.umd.coral.model.DataModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class SaveFigureDialog
extends JDialog
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 958293496362730699L;
    private JButton fileNavigateBtn;
    private JButton cancelBtn;
    private JButton okBtn;
    private JComboBox fileFormat;
    private JTextField filenameField;
    private DataModel model;
    private RenderedImage image;

    public SaveFigureDialog(Frame parent, boolean modal, DataModel model, RenderedImage image) {
        super(parent, modal);
        this.initComponents();
        this.model = model;
        this.image = image;
        this.addKeyListener(this);
        this.setDefaultCloseOperation(2);
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel("Save as:");
        this.filenameField = new JTextField();
        this.fileNavigateBtn = new JButton("Choose...");
        String[] formats = new String[]{"png"};
        this.fileFormat = new JComboBox<String>(formats);
        this.fileFormat.setPreferredSize(new Dimension(75, 27));
        this.cancelBtn = new JButton("Cancel");
        this.okBtn = new JButton("Save");
        this.okBtn.addActionListener(this);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(26, 20, 0, 0);
        this.getContentPane().add((Component)jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 174;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 10, 0, 0);
        this.getContentPane().add((Component)this.filenameField, gridBagConstraints);
        this.fileNavigateBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(21, 6, 0, 17);
        this.getContentPane().add((Component)this.fileNavigateBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.ipadx = -8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(22, 9, 0, 0);
        this.getContentPane().add((Component)this.fileFormat, gridBagConstraints);
        this.cancelBtn.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 17;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 6, 17, 17);
        this.getContentPane().add((Component)this.cancelBtn, gridBagConstraints);
        this.okBtn.setText("Save");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 13;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 9, 17, 0);
        this.getContentPane().add((Component)this.okBtn, gridBagConstraints);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.fileNavigateBtn) {
            FileNameExtensionFilter filter = new FileNameExtensionFilter("PNG file", "png");
            JFileChooser fc = new JFileChooser(this.model.getLastPath());
            fc.addChoosableFileFilter(filter);
            int retVal = fc.showSaveDialog(this);
            if (retVal != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            try {
                String s = f.getCanonicalPath();
                this.filenameField.setText(s);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else if (source == this.okBtn) {
            String name = this.filenameField.getText();
            String fileformat = (String)this.fileFormat.getSelectedItem();
            try {
                ImageIO.write(this.image, fileformat, new File(name));
                this.setVisible(false);
                this.dispose();
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this, "Could not save file", "Error", 0);
                e1.printStackTrace();
            }
        } else if (source == this.cancelBtn) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void keyTyped(KeyEvent e) {
        if (27 == e.getKeyCode()) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

