/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.dialog;

import edu.umd.coral.clustering.LAPSwingWorker;
import edu.umd.coral.clustering.ReorderingProgressDialog;
import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Matrix;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.infonode.docking.View;

public class ReorderMatrixDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 8643721408657143633L;
    private JButton reorderButton;
    private JButton cancelButton;
    private JSpinner greedyIter;
    private JSpinner optIter;
    private DataModel model;

    public ReorderMatrixDialog(JFrame parent, DataModel model) {
        super((Frame)parent, true);
        this.model = model;
        this.initComponents();
    }

    private void initComponents() {
        SpinnerNumberModel model = new SpinnerNumberModel(this.model.getMatrixGreedyIterations(), 0, 10, 1);
        this.greedyIter = new JSpinner(model);
        model = new SpinnerNumberModel(this.model.getMatrixOptIterations(), 0, 15, 1);
        this.optIter = new JSpinner(model);
        JLabel jLabel1 = new JLabel("greedy iterations");
        JLabel jLabel2 = new JLabel("optimal iterations");
        this.reorderButton = new JButton("Reorder");
        this.cancelButton = new JButton("Cancel");
        JLabel jLabel3 = new JLabel("Run the algorithm for:");
        this.setDefaultCloseOperation(2);
        this.setTitle("Reorder matrix");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReorderMatrixDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        this.setTitle("Reorder matrix");
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 30, 0, 0);
        this.getContentPane().add((Component)this.greedyIter, gridBagConstraints);
        jLabel1.setText("greedy iterations");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 10, 0, 0);
        this.getContentPane().add((Component)jLabel1, gridBagConstraints);
        jLabel2.setText("optimal iterations");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(22, 10, 0, 0);
        this.getContentPane().add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 14;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 30, 0, 0);
        this.getContentPane().add((Component)this.optIter, gridBagConstraints);
        this.reorderButton.setText("Reorder");
        this.reorderButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 0, 17, 17);
        this.getContentPane().add((Component)this.reorderButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(18, 75, 17, 0);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        jLabel3.setText("Run the algorithm for:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 20, 0, 0);
        this.getContentPane().add((Component)jLabel3, gridBagConstraints);
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ReorderMatrixDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ReorderMatrixDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ReorderMatrixDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ReorderMatrixDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ReorderMatrixDialog dialog = new ReorderMatrixDialog(new JFrame(), null);
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.reorderButton) {
            if (this.model != null) {
                int greedy = (Integer)this.greedyIter.getValue();
                int opt = (Integer)this.optIter.getValue();
                this.model.setMatrixGreedyIterations(greedy);
                this.model.setMatrixOptIterations(opt);
                this.model.setHighlightCliques(false);
                this.model.setOverlayCliques(false);
                View[] views = this.model.getViews();
                if (views == null || views.length < 1) {
                    return;
                }
                JFrame frame = this.model.getMainWindow();
                final ReorderingProgressDialog dialog = new ReorderingProgressDialog(frame);
                final LAPSwingWorker lapWorker = new LAPSwingWorker(this.model.getCurrentMatrix(), dialog, greedy, opt);
                dialog.cancelBtn.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Attempting to cancel reordering");
                        lapWorker.cancel(true);
                        dialog.setVisible(false);
                        dialog.dispose();
                    }
                });
                lapWorker.addPropertyChangeListener(dialog);
                lapWorker.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent e) {
                        if (e.getPropertyName().equals("state") && e.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                            LAPSwingWorker lapWorker = (LAPSwingWorker)e.getSource();
                            try {
                                Matrix m = (Matrix)lapWorker.get();
                                dialog.setVisible(false);
                                dialog.dispose();
                                ReorderMatrixDialog.this.model.setCurrentMatrix(m);
                            }
                            catch (InterruptedException e1) {
                                e1.printStackTrace();
                            }
                            catch (ExecutionException e1) {
                                e1.printStackTrace();
                            }
                            catch (CancellationException e1) {
                                System.out.println("Got a cancellation exception");
                                lapWorker.done();
                            }
                            ReorderMatrixDialog.this.setVisible(false);
                            ReorderMatrixDialog.this.dispose();
                        }
                    }
                });
                this.setVisible(false);
                this.dispose();
                dialog.pack();
                Point p = frame.getLocationOnScreen();
                Rectangle r = frame.getBounds();
                Dimension d = dialog.getPreferredSize();
                int x = p.x + (int)Math.floor(((double)r.width - d.getWidth()) / 2.0);
                int y = p.y + (int)Math.floor(((double)r.height - d.getHeight()) / 2.0);
                dialog.setLocation(x, y);
                lapWorker.execute();
                dialog.setVisible(true);
            }
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

