/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.control;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class ReorderableJList
extends JList
implements DragSourceListener,
DropTargetListener,
DragGestureListener {
    private static final long serialVersionUID = 8763588043309928483L;
    static DataFlavor localObjectFlavor;
    static DataFlavor[] supportedFlavors;
    DragSource dragSource;
    DropTarget dropTarget;
    Object dropTargetCell;
    int draggedIndex = -1;

    static {
        try {
            localObjectFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        supportedFlavors = new DataFlavor[]{localObjectFlavor};
    }

    public ReorderableJList() {
        this.setCellRenderer(new ReorderableListCellRenderer());
        this.setModel(new DefaultListModel());
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.dropTarget = new DropTarget(this, this);
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        Point clickPoint = dge.getDragOrigin();
        int index = this.locationToIndex(clickPoint);
        if (index == -1) {
            return;
        }
        Object target = this.getModel().getElementAt(index);
        RJLTransferable trans = new RJLTransferable(target);
        this.draggedIndex = index;
        this.dragSource.startDrag(dge, Cursor.getDefaultCursor(), trans, this);
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.dropTargetCell = null;
        this.draggedIndex = -1;
        this.repaint();
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dse) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (dtde.getSource() != this.dropTarget) {
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(3);
        }
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
        Point dragPoint;
        int index;
        if (dtde.getSource() != this.dropTarget) {
            dtde.rejectDrag();
        }
        this.dropTargetCell = (index = this.locationToIndex(dragPoint = dtde.getLocation())) == -1 ? null : this.getModel().getElementAt(index);
        this.repaint();
    }

    public void drop(DropTargetDropEvent dtde) {
        if (dtde.getSource() != this.dropTarget) {
            dtde.rejectDrop();
            return;
        }
        Point dropPoint = dtde.getLocation();
        int index = this.locationToIndex(dropPoint);
        boolean dropped = false;
        try {
            if (index == -1 || index == this.draggedIndex) {
                dtde.rejectDrop();
                return;
            }
            dtde.acceptDrop(2);
            Object dragged = dtde.getTransferable().getTransferData(localObjectFlavor);
            boolean sourceBeforeTarget = this.draggedIndex < index;
            DefaultListModel mod = (DefaultListModel)this.getModel();
            mod.remove(this.draggedIndex);
            mod.add(sourceBeforeTarget ? index - 1 : index, dragged);
            dropped = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dtde.dropComplete(dropped);
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public static void main(String[] args) {
        ReorderableJList list = new ReorderableJList();
        DefaultListModel<String> defModel = new DefaultListModel<String>();
        list.setModel(defModel);
        String[] listItems = new String[]{"Chris", "Joshua", "Daniel", "Michael", "Don", "Kimi", "Kelly", "Keagan"};
        Iterator<String> it = Arrays.asList(listItems).iterator();
        while (it.hasNext()) {
            defModel.addElement(it.next());
        }
        JScrollPane scroller = new JScrollPane(list, 22, 31);
        JFrame frame = new JFrame("Checkbox JList");
        frame.getContentPane().add(scroller);
        frame.pack();
        frame.setVisible(true);
    }

    class RJLTransferable
    implements Transferable {
        Object object;

        public RJLTransferable(Object o) {
            this.object = o;
        }

        public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(df)) {
                return this.object;
            }
            throw new UnsupportedFlavorException(df);
        }

        public boolean isDataFlavorSupported(DataFlavor df) {
            return df.equals(localObjectFlavor);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }
    }

    class ReorderableListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -5745008805518184485L;
        boolean isTargetCell;
        boolean isLastItem;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.isTargetCell = value == ReorderableJList.this.dropTargetCell;
            this.isLastItem = index == list.getModel().getSize() - 1;
            boolean showSelected = isSelected & ReorderableJList.this.dropTargetCell == null;
            return super.getListCellRendererComponent((JList<?>)list, value, index, showSelected, hasFocus);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isTargetCell) {
                g.setColor(Color.black);
                g.drawLine(0, 0, this.getSize().width, 0);
            }
        }
    }
}

