/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.control;

import edu.umd.coral.model.GradientColorModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.Formatter;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class DiscreteLegend
extends JComponent
implements MouseMotionListener {
    private static final long serialVersionUID = -7498972148139318741L;
    private final int minValue = 0;
    public static final int minBlockSize = 25;
    private int maxValue;
    public static final int gradientWidth = 10;
    private boolean isVertical = false;
    private boolean smooth = false;

    public DiscreteLegend(int maxValue) {
        this.maxValue = maxValue;
        this.addMouseMotionListener(this);
    }

    public void setMaxValue(int max) {
        this.maxValue = max;
        this.repaint();
    }

    private String getString(float value) {
        Formatter fmt = new Formatter();
        fmt.format("%.0f", Float.valueOf(value));
        String sv = fmt.toString();
        return sv;
    }

    public Dimension getPreferredSize() {
        Dimension minSize = this.getMinSize(this.getGraphics());
        Dimension d = new Dimension((int)minSize.getWidth(), (int)minSize.getHeight());
        this.smooth = false;
        if (this.isVertical && d.getHeight() > 210.0) {
            d.height = 210;
            this.smooth = true;
        }
        if (!this.isVertical && d.getWidth() > 210.0) {
            d.width = 210;
            this.smooth = true;
        }
        this.setMaximumSize(d);
        return d;
    }

    private Dimension getMinSize(Graphics g) {
        int minH;
        int minW;
        if (g == null) {
            return null;
        }
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D bounds1 = fm.getStringBounds(this.getString(0.0f), g);
        Rectangle2D bounds2 = fm.getStringBounds(this.getString(this.maxValue), g);
        if (this.isVertical) {
            minW = (int)Math.ceil(Math.max(bounds1.getWidth(), bounds2.getWidth())) + 10;
            minH = (int)Math.ceil(bounds1.getHeight() + bounds2.getHeight());
        } else {
            minW = (int)Math.max(bounds1.getWidth() + bounds2.getWidth(), (double)(25 * (this.maxValue - 0 + 1)));
            minH = (int)Math.ceil(Math.max(bounds1.getHeight(), bounds2.getHeight())) - 3 + 10;
        }
        Dimension d = new Dimension(minW, minH);
        this.setMinimumSize(d);
        return d;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Dimension d = this.getPreferredSize();
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D bounds1 = fm.getStringBounds(this.getString(0.0f), g);
        Rectangle2D bounds2 = fm.getStringBounds(this.getString(this.maxValue), g);
        int labelH = (int)Math.max(bounds1.getHeight(), bounds2.getHeight());
        labelH = Math.max(labelH, 10);
        int w = (int)Math.max(bounds1.getWidth() + bounds2.getWidth() + 5.0, this.getPreferredSize().getWidth());
        int yMid = (int)Math.floor((this.getPreferredSize().getHeight() - (double)labelH) / 2.0);
        int blockWidth = (int)Math.floor((double)(w - this.maxValue) / ((double)this.maxValue + 1.0));
        if (this.smooth) {
            g2d.setColor(Color.BLACK);
            g2d.fillRect(0, yMid, blockWidth, yMid + 10);
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, GradientColorModel.getMatrixColor(1.0, this.maxValue, false), d.width, 0.0f, GradientColorModel.getMatrixColor(this.maxValue, this.maxValue, false), false);
            g2d.setPaint(paint);
            g2d.fillRect(blockWidth, yMid, w, yMid + 10);
        } else {
            g2d.setColor(Color.BLACK);
            g2d.fillRect(0, yMid, blockWidth, labelH);
            int i = 1;
            while (i <= this.maxValue) {
                Color c = GradientColorModel.getMatrixColor(i, this.maxValue, false);
                g2d.setColor(c);
                g2d.fillRect(blockWidth * i + i, yMid, blockWidth, labelH);
                ++i;
            }
            g2d.setColor(Color.BLACK);
            i = 1;
            while (i <= this.maxValue) {
                g2d.drawLine(blockWidth * i + i - 1, yMid, blockWidth * i + i - 1, yMid + labelH - 1);
                ++i;
            }
        }
        g2d.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(this.getString(0.0f), g2d);
        int componentH = (int)this.getPreferredSize().getHeight();
        g2d.setColor(Color.WHITE);
        g2d.drawString(this.getString(0.0f), (int)((double)blockWidth - bounds.getWidth()) / 2, componentH - yMid - 3);
        g2d.setColor(Color.BLACK);
        g2d.drawString(this.getString(1.0f), (int)((double)blockWidth - bounds.getWidth()) / 2 + blockWidth, componentH - yMid - 3);
        bounds = fm.getStringBounds(this.getString(this.maxValue), g2d);
        g2d.drawString(this.getString(this.maxValue), (int)((double)(d.width - blockWidth) + ((double)blockWidth - bounds.getWidth()) / 2.0), componentH - yMid - 3);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiscreteLegend.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        JFrame f = new JFrame("Swing Gradient Demo");
        f.setDefaultCloseOperation(3);
        DiscreteLegend panel = new DiscreteLegend(10);
        f.setPreferredSize(new Dimension(200, 100));
        f.getContentPane().add(panel);
        f.pack();
        f.setVisible(true);
    }

    public void mouseDragged(MouseEvent arg0) {
    }

    public void mouseMoved(MouseEvent e) {
        Graphics g = this.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D bounds1 = fm.getStringBounds(this.getString(0.0f), g);
        Rectangle2D bounds2 = fm.getStringBounds(this.getString(this.maxValue), g);
        int w = (int)Math.max(bounds1.getWidth() + bounds2.getWidth() + 5.0, this.getPreferredSize().getWidth());
        int blockWidth = (w - this.maxValue + 1) / this.maxValue;
        int x = e.getX();
        int value = 0;
        int i = 0;
        while (i <= this.maxValue) {
            if (blockWidth * (i - 1) + (i - 1) < x && x < blockWidth * i + i - 2) {
                value = i;
                break;
            }
            ++i;
        }
        if (value > 0) {
            this.setToolTipText(String.valueOf(value));
        } else {
            this.setToolTipText("");
        }
    }
}

