/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui.control;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.GradientColorModel;
import edu.umd.coral.model.data.Matrix;
import edu.umd.coral.ui.JPanelExt;
import edu.umd.coral.ui.slider.RangeSlider;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CutOffValuesSlider
extends JPanelExt
implements PropertyChangeListener,
ChangeListener {
    private RangeSlider slider;
    private static final long serialVersionUID = 4367885157464050088L;

    public CutOffValuesSlider(DataModel model) {
        super(model);
        this.setLayout(new BoxLayout(this, 1));
        this._dataModel.addPropertyChangeListener("originalMatrixChanged", this);
        this._dataModel.addPropertyChangeListener("currentMatrixChanged", this);
        TitledBorder leftBorder = BorderFactory.createTitledBorder("Filter matrix values");
        leftBorder.setTitleJustification(1);
        this.setBorder(leftBorder);
        this.slider = new RangeSlider();
        this.slider.setMinimum(0);
        this.slider.setMaximum(10);
        this.slider.setDrawGradient(true);
        this.slider.setValue(0);
        this.slider.setUpperValue(10);
        this.slider.setMajorTickSpacing(2);
        this.slider.setMinorTickSpacing(1);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.addChangeListener(this);
        this.slider.setAlignmentX(0.0f);
        this.add(this.slider);
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.slider.setValue(0);
        Matrix matrix = this._dataModel.getCurrentMatrix();
        if (matrix != null) {
            int max = (int)matrix.getMax();
            this.slider.setMaximum(max);
            this.slider.setUpperValue(max);
            System.out.println("curr matrix max: " + max);
        }
    }

    public void stateChanged(ChangeEvent arg0) {
        int lowerValue = this.slider.getValue();
        int upperValue = this.slider.getUpperValue();
        Color startColor = GradientColorModel.getGradientColor(Color.RED, Color.GREEN, lowerValue / this.slider.getMaximum(), false);
        Color endColor = GradientColorModel.getGradientColor(Color.RED, Color.GREEN, upperValue / this.slider.getMaximum(), false);
        this.slider.setStartColor(startColor);
        this.slider.setEndColor(endColor);
        System.out.println("slider: " + lowerValue + " " + upperValue);
        this._dataModel.setLowerBound(lowerValue);
        this._dataModel.setUpperBound(upperValue);
    }
}

