/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.ui;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.ui.BarShapeRenderer;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.DataColorAction;
import prefuse.action.assignment.DataShapeAction;
import prefuse.action.layout.AxisLabelLayout;
import prefuse.action.layout.AxisLayout;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.query.RangeQueryBinding;
import prefuse.data.tuple.TupleSet;
import prefuse.render.AbstractShapeRenderer;
import prefuse.render.AxisRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;
import prefuse.visual.expression.VisiblePredicate;

public class MyDisplay
extends Display
implements PropertyChangeListener {
    private static final long serialVersionUID = 1219876384252040361L;
    public static final String GROUP_NAME = "clustering";
    private Rectangle2D m_dataB = new Rectangle2D.Double();
    private Rectangle2D m_xlabB = new Rectangle2D.Double();
    private Rectangle2D m_ylabB = new Rectangle2D.Double();
    private DataModel _dataModel;
    private Table dataTable;
    private AxisLayout xaxis;
    private AxisLayout yaxis;

    public MyDisplay(DataModel model) {
        super(new Visualization());
        this._dataModel = model;
        if (this._dataModel != null) {
            this._dataModel.addPropertyChangeListener("clusteringsChanged", this);
        }
    }

    private Table generateData() {
        Map<String, Clustering> map = this._dataModel.getClusterings();
        if (map == null) {
            this.dataTable = null;
            return null;
        }
        Collection<Clustering> clusterings = map.values();
        Iterator<Clustering> iterator = clusterings.iterator();
        int i = 0;
        Table myTable = new Table();
        myTable.addColumn("name", String.class);
        myTable.addColumn("moduleCount", Integer.class);
        while (iterator.hasNext()) {
            Clustering c = iterator.next();
            myTable.addRow();
            Tuple tuple = myTable.getTuple(i);
            tuple.set("name", (Object)c.getName());
            tuple.set("moduleCount", (Object)c.getModules().size());
            myTable.addTuple(tuple);
            ++i;
        }
        return myTable;
    }

    private void initVisualization() {
        if (this.dataTable == null) {
            return;
        }
        VisualTable visualTable = this.m_vis.addTable(GROUP_NAME, this.dataTable);
        visualTable.addColumn("label", "CONCAT(CAP(name), ': ', moduleCount)");
        this.m_vis.setRendererFactory(new RendererFactory(){
            AbstractShapeRenderer sr = new BarShapeRenderer();
            Renderer arY = new AxisRenderer(0, 4);
            Renderer arX = new AxisRenderer(2, 7);

            public Renderer getRenderer(VisualItem item) {
                return item.isInGroup("ylab") ? this.arY : (item.isInGroup("xlab") ? this.arX : this.sr);
            }
        });
        AxisLabelLayout xlabels = this.addAxisX(GROUP_NAME);
        AxisLabelLayout ylabels = this.addAxisY(GROUP_NAME, visualTable);
        int[] palette = new int[]{ColorLib.rgb((int)150, (int)150, (int)255)};
        DataColorAction color = new DataColorAction(GROUP_NAME, "name", 1, VisualItem.STROKECOLOR, palette);
        int[] shapes = new int[1];
        DataShapeAction shape = new DataShapeAction(GROUP_NAME, "name", shapes);
        ActionList draw = new ActionList();
        draw.add((Action)color);
        draw.add((Action)shape);
        draw.add((Action)this.xaxis);
        draw.add((Action)this.yaxis);
        draw.add((Action)xlabels);
        draw.add((Action)ylabels);
        draw.add((Action)new ColorAction(GROUP_NAME, VisualItem.FILLCOLOR, 0));
        draw.add((Action)new RepaintAction());
        this.m_vis.putAction("draw", (Action)draw);
        ActionList update = new ActionList();
        update.add((Action)this.xaxis);
        update.add((Action)this.yaxis);
        update.add((Action)xlabels);
        update.add((Action)ylabels);
        update.add((Action)new RepaintAction());
        this.m_vis.putAction("update", (Action)update);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.setHighQuality(true);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                MyDisplay.this.updateLayout();
            }
        });
        this.updateLayout();
        this.m_vis.run("draw");
        this.m_vis.run("xlabels");
    }

    private AxisLabelLayout addAxisX(String group) {
        this.xaxis = new AxisLayout(group, "name", 0, VisiblePredicate.TRUE);
        this.m_vis.putAction("x", (Action)this.xaxis);
        this.xaxis.setLayoutBounds(this.m_dataB);
        AxisLabelLayout xlabels = new AxisLabelLayout("xlab", this.xaxis, this.m_xlabB, 15.0);
        this.m_vis.putAction("xlabels", (Action)xlabels);
        return xlabels;
    }

    private AxisLabelLayout addAxisY(String group, VisualTable visualTable) {
        this.yaxis = new AxisLayout(group, "moduleCount", 1, VisiblePredicate.TRUE);
        this.m_vis.putAction("y", (Action)this.yaxis);
        this.yaxis.setLayoutBounds(this.m_dataB);
        RangeQueryBinding range = new RangeQueryBinding((TupleSet)visualTable, "moduleCount");
        this.yaxis.setRangeModel(range.getModel());
        AxisLabelLayout ylabels = new AxisLabelLayout("ylab", this.yaxis, this.m_ylabB);
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setMaximumFractionDigits(0);
        ylabels.setNumberFormat(nf);
        this.m_vis.putAction("ylabels", (Action)ylabels);
        return ylabels;
    }

    private void updateLayout() {
        Insets insets = this.getInsets();
        int w = this.getWidth();
        int h = this.getHeight();
        int iw = insets.left + insets.right;
        int ih = insets.top + insets.bottom;
        int paddingHoriz = 85;
        int paddingVert = 15;
        this.m_dataB.setRect(insets.left, insets.top, w - iw - paddingHoriz, h - ih - paddingVert);
        this.m_xlabB.setRect(insets.left, h - paddingVert - insets.bottom, w - iw - paddingHoriz, paddingVert - 10);
        this.m_ylabB.setRect(insets.left, insets.top, w - iw, h - ih - paddingVert);
        this.m_vis.run("update");
        this.m_vis.run("xlabels");
    }

    public void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("clusteringsChanged")) {
            this.dataTable = this.generateData();
            this.initVisualization();
        }
    }
}

