/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.parse;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.model.parse.ModuleFilesParser;
import edu.umd.coral.model.parse.Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VertexFileParser
extends Parser {
    private String[] clusteringNames;

    public void parse(String fileName, DataModel model) throws Exception {
        if (fileName == null) {
            return;
        }
        this.clusterings = new HashMap();
        this.vertices = new HashMap();
        ArrayList<Vertex> rowOrdering = new ArrayList<Vertex>();
        this.vertexIndex = 0;
        try {
            String nextLine;
            long timeBefore = System.currentTimeMillis();
            Boolean has_header = true;
            File f = new File(fileName);
            InputStreamReader fis = new InputStreamReader(new FileInputStream(f));
            BufferedReader br = new BufferedReader(fis);
            while ((nextLine = br.readLine()) != null) {
                String[] parts = nextLine.split("[\\s,;]");
                if (has_header.booleanValue()) {
                    this.parseHeader(parts);
                    has_header = false;
                    continue;
                }
                this.parseVertexLine(parts, rowOrdering);
            }
            for (Clustering c : this.clusterings.values()) {
                c.setOriginalVertexCount(c.getVertexCount());
            }
            model.setInitialVertexOrder(rowOrdering);
            model.setVertices(this.vertices);
            model.setClusterings(this.clusterings);
            ArrayList<Clustering> ordering = new ArrayList<Clustering>(this.clusterings.values());
            Collections.sort(ordering);
            model.setClusteringOrdering(ordering);
            model.firePropertyChange("networkLoaded", false, true);
            long timeAfter = System.currentTimeMillis();
            System.out.println("Loaded in " + (timeAfter - timeBefore) + "ms");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseVertexLine(String[] nextLine, ArrayList<Vertex> rowOrdering) throws Exception {
        String vertexName = nextLine[0].trim();
        Vertex v = new Vertex(vertexName, this.vertexIndex);
        this.vertices.put(nextLine[0], v);
        rowOrdering.add(v);
        int i = 1;
        while (i < nextLine.length) {
            if (nextLine.length > this.clusteringNames.length + 1) {
                System.out.println("Invalid format. Skipping line: " + nextLine[0]);
            } else {
                Module m;
                String moduleName;
                String clusteringName = this.clusteringNames[i - 1];
                Clustering clustering = (Clustering)this.clusterings.get(clusteringName);
                if (clustering.hasModule(moduleName = nextLine[i].trim())) {
                    m = clustering.getModule(moduleName);
                    clustering.addToModule(moduleName, v);
                } else {
                    m = new Module(moduleName, clustering);
                    m.addVertex(v);
                    clustering.addModule(m);
                }
            }
            ++i;
        }
        ++this.vertexIndex;
    }

    private void parseHeader(String[] nextLine) {
        this.clusteringNames = new String[nextLine.length - 1];
        int i = 1;
        while (i < nextLine.length) {
            String name = nextLine[i].trim();
            Clustering clustering = new Clustering(name);
            clustering.setColor(ModuleFilesParser.getColor(i - 1));
            this.clusterings.put(name, clustering);
            this.clusteringNames[i - 1] = name;
            ++i;
        }
    }
}

