/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.parse;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class KarateClubParser {
    public void parseKarate(String path, String fileName) {
        try {
            String line;
            BufferedReader input = new BufferedReader(new FileReader(String.valueOf(path) + "/" + fileName));
            BufferedWriter out = null;
            while ((line = input.readLine()) != null) {
                if (line.contains("== ")) {
                    if (out != null) {
                        out.close();
                    }
                    out = this.parseKarateLine(line, String.valueOf(path) + "/clusterings");
                    continue;
                }
                this.parseClusterLine(line, out);
            }
            if (out != null) {
                out.close();
            }
            input.close();
        }
        catch (FileNotFoundException input) {
        }
        catch (IOException e) {
            System.out.println("Could not read file");
            e.printStackTrace();
        }
    }

    private void parseClusterLine(String line, BufferedWriter out) throws IOException {
        if (out == null) {
            return;
        }
        out.write(String.valueOf(line) + "\n");
    }

    private BufferedWriter parseKarateLine(String line, String path) throws IOException {
        String[] parts = line.trim().split(" ");
        String clusteringName = parts[1];
        String modularity = parts[3];
        String distance = parts[6];
        String fileName = String.valueOf(clusteringName) + "_" + modularity + "_" + distance;
        BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(path) + "/" + fileName));
        return out;
    }

    public static void main(String[] argv) {
        KarateClubParser parser = new KarateClubParser();
        parser.parseKarate("../data/karate_club", "karate_gml_kfast.clust");
    }
}

