/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.parse;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Edge;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.model.parse.Parser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgeFileParser
extends Parser {
    public void parse(String fileName, DataModel model) {
        try {
            String line;
            long timeBefore = System.currentTimeMillis();
            File f = new File(fileName);
            InputStreamReader fis = new InputStreamReader(new FileInputStream(f));
            BufferedReader br = new BufferedReader(fis);
            HashSet<Edge<Vertex>> edges = new HashSet<Edge<Vertex>>();
            Map<String, Vertex> vertices = model.getVertices();
            while ((line = br.readLine()) != null) {
                line = line.trim();
                this.parseLine(line, edges, vertices);
            }
            if (edges.size() == 0) {
                System.out.println("No edges in the edge file.");
            } else {
                model.setEdges(edges);
                model.setHasEdges(true);
            }
            long timeAfter = System.currentTimeMillis();
            System.out.println("parsed network file: " + edges.size());
            System.out.println("Loaded in " + (timeAfter - timeBefore) + "ms");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeNNF(DataModel model) throws IOException {
        Map<String, Clustering> map = model.getClusterings();
        for (Map.Entry<String, Clustering> entry : map.entrySet()) {
            Vertex v;
            int j;
            Vertex u;
            int i;
            Clustering c = entry.getValue();
            File f = new File(String.valueOf(c.getName()) + ".nnf");
            OutputStreamWriter fis = new OutputStreamWriter(new FileOutputStream(f));
            BufferedWriter br = new BufferedWriter(fis);
            Collection<Module> modules = c.getModules();
            for (Module m : modules) {
                ArrayList<Vertex> vertices = m.getVertices();
                ArrayList<Vertex> vertList = new ArrayList<Vertex>(vertices);
                int len = vertList.size();
                i = 0;
                while (i < len) {
                    u = vertList.get(i);
                    j = i + 1;
                    while (j < len) {
                        v = vertList.get(j);
                        if (u.hasNeighbor(v)) {
                            br.write(String.valueOf(m.getName()) + " " + u.getName() + " pp " + v.getName() + "\n");
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            ArrayList<Module> moduleList = new ArrayList<Module>(modules);
            int modLen = moduleList.size();
            boolean foundMatch = false;
            i = 0;
            while (i < modLen) {
                Module m1 = moduleList.get(i);
                ArrayList<Vertex> vert1 = new ArrayList<Vertex>(m1.getVertices());
                if (m1.getSize() >= 2) {
                    j = i + 1;
                    while (j < modLen) {
                        Module m2 = moduleList.get(j);
                        if (m2.getSize() >= 2) {
                            ArrayList<Vertex> vert2 = new ArrayList<Vertex>(m2.getVertices());
                            foundMatch = false;
                            int k = 0;
                            while (k < vert1.size() && !foundMatch) {
                                u = vert1.get(k);
                                int l = 0;
                                while (l < vert2.size() && !foundMatch) {
                                    v = vert2.get(l);
                                    if (u.equals(v) || u.hasNeighbor(v)) {
                                        br.write("big_net " + m1.getName() + " im " + m2.getName() + "\n");
                                        foundMatch = true;
                                    }
                                    ++l;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            br.close();
        }
    }

    private void parseLine(String line, Set<Edge<Vertex>> edges, Map<String, Vertex> vertices) throws IOException {
        String[] parts = (line = line.trim()).split("[(\\s+),;]");
        if (parts.length < 2) {
            return;
        }
        Vertex u = vertices.get(parts[0]);
        Vertex v = vertices.get(parts[1]);
        if (u == null || v == null) {
            return;
        }
        Edge<Vertex> e = new Edge<Vertex>(u, v);
        u.addNeighbor(v);
        v.addNeighbor(u);
        edges.add(e);
    }

    public static void print(String s) {
    }
}

