/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.metrics;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.model.metrics.Metric;

public class MutualInformation
implements Metric {
    public float getScore(Clustering c1, Clustering c2, boolean includeGrabBag) throws Exception {
        if (c1.getVertexCount() != c2.getVertexCount()) {
            throw new Exception("sizes don't match");
        }
        int N1 = c1.getVertexCount();
        int N2 = c2.getVertexCount();
        float I = 0.0f;
        for (Module m1 : c1.getModules()) {
            if (!includeGrabBag && m1.getName().equals("__misc__")) continue;
            float p_k1 = (float)m1.getSize() * 1.0f / (float)N1;
            for (Module m2 : c2.getModules()) {
                if (!includeGrabBag && m2.getName().equals("__misc__")) continue;
                float p_k2 = (float)m2.getSize() * 1.0f / (float)N2;
                float P_k1_k2 = (float)this.getUnionSize(m1, m2) * 1.0f / (float)(N1 + N2);
                if (P_k1_k2 == 0.0f) continue;
                I = (float)((double)I + (double)P_k1_k2 * Math.log10(P_k1_k2 / (p_k1 * p_k2)));
            }
        }
        return I;
    }

    private int getUnionSize(Module m1, Module m2) {
        int size = 0;
        for (Vertex v : m1.getVertices()) {
            for (Vertex u : m2.getVertices()) {
                if (!v.equals(u)) continue;
                ++size;
            }
        }
        return size;
    }

    public String getName() {
        return "Mutual Information";
    }

    public String toString() {
        return "Mutual Information";
    }

    public String getAnnotation() {
        return "<html><b>Mutual information</b> - information that C1 and C2 share (how<br>much knowing one of these variables reduces uncertainty<br>about the other).</html>";
    }
}

