/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.metrics;

import edu.umd.coral.model.metrics.FMeasureMetric;
import edu.umd.coral.model.metrics.FolkesMetric;
import edu.umd.coral.model.metrics.InversePurity;
import edu.umd.coral.model.metrics.JaccardMetric;
import edu.umd.coral.model.metrics.Metric;
import edu.umd.coral.model.metrics.MirkinMetric;
import edu.umd.coral.model.metrics.MutualInformation;
import edu.umd.coral.model.metrics.PurityMetric;
import edu.umd.coral.model.metrics.RandIndex;
import edu.umd.coral.model.metrics.VariationOfInformation;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class MetricFactory {
    public static final String VI = "Variation of information";
    public static final String MI = "Mutual information";
    public static final String MIRKIN = "Mirkin";
    public static final String RAND = "Rand";
    public static final String JACCARD = "Jaccard";
    public static final String PURITY = "Purity";
    public static final String INV_PURITY = "Inverse purity";
    public static final String FMEASURE = "F-measure";
    public static final String FOLKES = "Folkes-Mallows";
    private static final Metric JACCARD_METRIC = new JaccardMetric();

    public static Metric getMetricInstance(String requestedMetric) throws NotImplementedException {
        if (VI.equals(requestedMetric)) {
            return new VariationOfInformation();
        }
        if (MI.equals(requestedMetric)) {
            return new MutualInformation();
        }
        if (RAND.equals(requestedMetric)) {
            return new RandIndex();
        }
        if (JACCARD.equals(requestedMetric)) {
            return JACCARD_METRIC;
        }
        if (MIRKIN.equals(requestedMetric)) {
            return new MirkinMetric();
        }
        if (PURITY.equals(requestedMetric)) {
            return new PurityMetric();
        }
        if (INV_PURITY.equals(requestedMetric)) {
            return new InversePurity();
        }
        if (FMEASURE.equals(requestedMetric)) {
            return new FMeasureMetric();
        }
        if (FOLKES.equals(requestedMetric)) {
            return new FolkesMetric();
        }
        throw new NotImplementedException();
    }
}

