/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.metrics;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.metrics.Metric;

public class InversePurity
implements Metric {
    public String getName() {
        return "Inverse purity";
    }

    public float getScore(Clustering experiment, Clustering truth, boolean includeGrabBag) {
        float sum = 0.0f;
        for (Module l_i : truth.getModules()) {
            if (!includeGrabBag && l_i.getName().equals("__misc__")) continue;
            float precision = 0.0f;
            float max = 0.0f;
            for (Module c_j : experiment.getModules()) {
                if (!includeGrabBag && c_j.getName().equals("__misc__") || !((precision = (float)c_j.getIntersection(l_i).size() * 1.0f) > max)) continue;
                max = precision;
            }
            sum += max;
        }
        return sum / (float)experiment.getVertexCount();
    }

    public String toString() {
        return "Inverse purity";
    }

    public String getAnnotation() {
        return "<html><b>Inverse purity</b> - assumming that one clustering is obtained through an experiment <br>and another one represents the truth, shows how whether the elements from the same category<br>tend to cluster in the same experimental module</html>";
    }
}

