/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.data;

import edu.umd.coral.model.data.Named;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vertex
implements Comparable<Vertex>,
Named {
    private String _name;
    private int _index = 0;
    private Map<Vertex, Double> _neighbors = new TreeMap<Vertex, Double>();

    public Vertex(String name, int index) {
        this._name = name;
        this._index = index;
    }

    public Vertex(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public int getIndex() {
        return this._index;
    }

    public void addNeighbor(Vertex v) {
        if (this._neighbors == null) {
            this._neighbors = new HashMap<Vertex, Double>();
        }
        this._neighbors.put(v, 1.0);
        if (v._neighbors == null) {
            v._neighbors = new HashMap<Vertex, Double>();
        }
        v._neighbors.put(this, 1.0);
    }

    public void addNeighbor(Vertex v, double f) {
        this._neighbors.put(v, f);
    }

    public void setEdgeWeight(Vertex v, double f) {
        this._neighbors.put(v, f);
    }

    public double getEdgeWeight(Vertex v) {
        return this._neighbors.get(v);
    }

    public Collection<Vertex> getNeighbors() {
        return this._neighbors.keySet();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Vertex)) {
            return false;
        }
        Vertex v = (Vertex)o;
        if (this._name == null) {
            return v.getName() == null;
        }
        return this._name.equals(v.getName()) && this._index == v._index;
    }

    @Override
    public int compareTo(Vertex u) {
        if (u == null) {
            return 1;
        }
        return this._name.compareTo(u._name);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public String toString() {
        return this._name;
    }

    public int getDegree() {
        return this._neighbors.size();
    }

    public boolean hasNeighbor(Vertex v) {
        return this._neighbors.containsKey(v);
    }

    public double getEdgeSum() {
        double sum = 0.0;
        if (this._neighbors != null) {
            for (double weight : this._neighbors.values()) {
                sum += weight;
            }
        }
        return sum;
    }
}

