/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.data;

import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.data.Vertex;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulePair {
    private Module m1;
    private Module m2;
    private ArrayList<Vertex> oneMinusTwo;
    private ArrayList<Vertex> twoMinusOne;
    private ArrayList<Vertex> onePlusTwo;
    private ArrayList<Vertex> intersection;
    private float score;
    private float module1Ratio;
    private float module2Ratio;
    private int module1Size;
    private int module2Size;

    public ModulePair(Module m1, Module m2, float score) {
        this.m1 = m1;
        this.m2 = m2;
        this.score = score;
        this.oneMinusTwo = m1.getDifference(m2);
        this.twoMinusOne = m2.getDifference(m1);
        this.onePlusTwo = m1.getUnion(m2);
        this.module1Ratio = m1.getInOutRatio();
        this.module2Ratio = m2.getInOutRatio();
        this.intersection = m1.getIntersection(m2);
    }

    public ArrayList<Vertex> getLeftDifference() {
        return this.oneMinusTwo;
    }

    public ArrayList<Vertex> getRightDifference() {
        return this.twoMinusOne;
    }

    public ArrayList<Vertex> getUnion() {
        return this.onePlusTwo;
    }

    public ArrayList<Vertex> getIntersection() {
        return this.intersection;
    }

    public Module getM1() {
        return this.m1;
    }

    public Module getM2() {
        return this.m2;
    }

    public Collection<Vertex> getOneMinusTwo() {
        return this.oneMinusTwo;
    }

    public Collection<Vertex> getTwoMinusOne() {
        return this.twoMinusOne;
    }

    public Collection<Vertex> getOnePlusTwo() {
        return this.onePlusTwo;
    }

    public float getScore() {
        return this.score;
    }

    public float getModule1Ratio() {
        return this.module1Ratio;
    }

    public float getModule2Ratio() {
        return this.module2Ratio;
    }

    public int getModule1Size() {
        return this.module1Size;
    }

    public int getModule2Size() {
        return this.module2Size;
    }

    public ArrayList<Vertex> getValue(String name) {
        if (name.equals("m1 \u2229 m2")) {
            return this.getIntersection();
        }
        if (name.equals("m1 \\ m2")) {
            return this.getLeftDifference();
        }
        if (name.equals("m2 \\ m1")) {
            return this.getRightDifference();
        }
        if (name.equals("m1 \u222a m2")) {
            return this.getUnion();
        }
        if (name.equals("m1")) {
            return this.getM1().getVertices();
        }
        if (name.equals("m2")) {
            return this.getM2().getVertices();
        }
        return null;
    }
}

