/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.data;

import Jama.EigenvalueDecomposition;
import edu.umd.coral.model.data.BitSymmetricMatrix;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Matrix {
    public String[] rowNames;
    public String[] columnNames;
    protected int row_count = 0;
    protected int column_count = 0;
    private double _maximum = 0.0;
    private double[][] _data;

    public Matrix() {
    }

    public Matrix(int N, int M) {
        this.row_count = N;
        this.column_count = M;
        this._data = new double[this.row_count][this.column_count];
        this.rowNames = new String[this.row_count];
        this.columnNames = new String[this.column_count];
    }

    public Matrix(String[] rowNames, String[] columnNames) throws NullPointerException {
        if (rowNames == null) {
            throw new NullPointerException();
        }
        if (columnNames == null) {
            throw new NullPointerException();
        }
        this.rowNames = rowNames;
        this.columnNames = columnNames;
        this.row_count = rowNames.length;
        this.column_count = columnNames.length;
        this._data = new double[this.row_count][this.column_count];
    }

    public Matrix(double[][] data, String[] rowNames, String[] columnNames) {
        this._data = data;
        this.rowNames = rowNames;
        this.columnNames = columnNames;
        if (rowNames != null) {
            this.row_count = rowNames.length;
        }
        if (columnNames != null) {
            this.column_count = columnNames.length;
        }
    }

    public Matrix(ArrayList<double[]> rowsArray, String[] rowNames, String[] columnNames, double f) {
        this._data = (double[][])rowsArray.toArray((T[])new double[0][]);
        this.rowNames = rowNames;
        this.columnNames = columnNames;
        if (rowNames != null) {
            this.row_count = rowNames.length;
        }
        if (columnNames != null) {
            this.column_count = columnNames.length;
        }
        this._maximum = f;
    }

    public Matrix(double[][] data, String[] rowNames, String[] columnNames, double max) {
        this._data = data;
        this.rowNames = rowNames;
        this.columnNames = columnNames;
        if (rowNames != null) {
            this.row_count = rowNames.length;
        }
        if (columnNames != null) {
            this.column_count = columnNames.length;
        }
        this._maximum = max;
    }

    public Matrix(FlexCompRowMatrix m, String[] col_names, String[] row_names) {
        int size = col_names.length;
        this._data = new double[size][size];
        this.columnNames = col_names;
        this.rowNames = row_names;
        this.column_count = this.row_count = size;
        for (MatrixEntry me : m) {
            this._data[me.row()][me.column()] = me.get();
        }
    }

    public double[][] getData() {
        return this._data;
    }

    public double getMax() {
        return this._maximum;
    }

    public double getElement(int row, int column) {
        if (row >= this.row_count || column >= this.column_count) {
            throw new IndexOutOfBoundsException();
        }
        return this._data[row][column];
    }

    public void setElement(int row, int column, int value) {
        if (row >= this.row_count || column >= this.column_count) {
            throw new IndexOutOfBoundsException();
        }
        this._data[row][column] = value;
        if ((double)value > this._maximum) {
            this._maximum = value;
        }
    }

    public void setElement(String row, String column, int value) {
        int r = 0;
        int c = 0;
        int i = 0;
        while (i < this.rowNames.length) {
            if (this.rowNames[i].equals(row)) {
                r = i;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.columnNames.length) {
            if (this.columnNames[i].equals(row)) {
                c = i;
                break;
            }
            ++i;
        }
        this._data[r][c] = value;
    }

    public Matrix addMatrix(Matrix m) {
        if (m.getColumnCount() != this.column_count || m.getRowCount() != this.row_count) {
            throw new IndexOutOfBoundsException();
        }
        Matrix sum = Matrix.generateEmptySymMatrix(this.row_count, m.rowNames);
        int i = 0;
        while (i < this.row_count) {
            int j = 0;
            while (j < this.column_count) {
                sum._data[i][j] = this._data[i][j] + m._data[i][j];
                if (sum._data[i][j] > sum._maximum) {
                    sum._maximum = sum._data[i][j];
                }
                ++j;
            }
            ++i;
        }
        return sum;
    }

    public Matrix addMatrix(BitSymmetricMatrix m) {
        Matrix sum = Matrix.generateEmptySymMatrix(this.row_count, m.rowNames);
        int i = 0;
        while (i < this.row_count) {
            int j = 0;
            while (j < this.column_count) {
                sum._data[i][j] = this._data[i][j] + m.getElement(i, j);
                if (sum._data[i][j] > sum._maximum) {
                    sum._maximum = sum._data[i][j];
                }
                ++j;
            }
            ++i;
        }
        return sum;
    }

    public static Matrix generateEmptySymMatrix(int rowCount, String[] names) {
        Matrix copy = new Matrix(rowCount, rowCount);
        copy.columnNames = names;
        copy.rowNames = names;
        return copy;
    }

    public Matrix subtractMatrix(Matrix m) {
        if (m.getColumnCount() != this.column_count || m.getRowCount() != this.row_count) {
            throw new IndexOutOfBoundsException();
        }
        Matrix diff = new Matrix(this.row_count, this.column_count);
        diff.columnNames = this.columnNames;
        diff.rowNames = this.rowNames;
        int i = 0;
        while (i < this.row_count) {
            int j = 0;
            while (j < this.column_count) {
                diff._data[i][j] = this._data[i][j] - m._data[i][j];
                if (diff._data[i][j] > diff._maximum) {
                    diff._maximum = diff._data[i][j];
                }
                ++j;
            }
            ++i;
        }
        return diff;
    }

    public Matrix subtractMatrix(BitSymmetricMatrix m) {
        if (m.getColumnCount() != this.column_count || m.getRowCount() != this.row_count) {
            throw new IndexOutOfBoundsException();
        }
        Matrix diff = new Matrix(this.row_count, this.column_count);
        diff.columnNames = this.columnNames;
        diff.rowNames = this.rowNames;
        int i = 0;
        while (i < this.row_count) {
            int j = 0;
            while (j < this.column_count) {
                diff._data[i][j] = this._data[i][j] - m.getElement(i, j);
                if (diff._data[i][j] > diff._maximum) {
                    diff._maximum = diff._data[i][j];
                }
                ++j;
            }
            ++i;
        }
        return diff;
    }

    public int getRowCount() {
        return this.row_count;
    }

    public int getColumnCount() {
        return this.column_count;
    }

    public String getRowName(int row) {
        if (row >= this.row_count) {
            throw new IndexOutOfBoundsException();
        }
        return this.rowNames[row];
    }

    public String getColumnName(int column) {
        if (column >= this.column_count) {
            throw new IndexOutOfBoundsException();
        }
        return this.columnNames[column];
    }

    public void setFilteredData(double[][] data, int lowCutOff, int highCutOff) {
        int i = 0;
        while (i < this.row_count) {
            int j = 0;
            while (j < this.column_count) {
                if (data[i][j] >= (double)lowCutOff && data[i][j] <= (double)highCutOff) {
                    this._data[i][j] = data[i][j];
                    if (this._data[i][j] > this._maximum) {
                        this._maximum = this._data[i][j];
                    }
                } else {
                    this._data[i][j] = 0.0;
                }
                ++j;
            }
            ++i;
        }
    }

    public double[] getRow(int i) throws IndexOutOfBoundsException {
        if (i < 0 || i >= this.row_count) {
            throw new IndexOutOfBoundsException();
        }
        return this._data[i];
    }

    public String toString() {
        String output = "\t";
        int j = 0;
        while (j < this.column_count) {
            output = String.valueOf(output) + this.columnNames[j] + "\t";
            ++j;
        }
        output = String.valueOf(output) + "\n";
        int i = 0;
        while (i < this.row_count) {
            output = String.valueOf(output) + this.rowNames[i] + "\t";
            j = 0;
            while (j < this.column_count) {
                output = this._data[i][j] == 0.0 ? String.valueOf(output) + "   \t" : String.valueOf(output) + this._data[i][j] + "\t";
                ++j;
            }
            output = String.valueOf(output) + "\n";
            ++i;
        }
        return output;
    }

    public StringBuilder toStringBuilder(String delimiter) {
        StringBuilder output = new StringBuilder(delimiter);
        int j = 0;
        while (j < this.column_count) {
            output.append(String.valueOf(this.columnNames[j]) + delimiter);
            ++j;
        }
        output.append("\n");
        int i = 0;
        while (i < this.row_count) {
            j = 0;
            while (j < this.column_count) {
                output.append(this._data[i][j]);
                output.append(delimiter);
                ++j;
            }
            output.append("\n");
            ++i;
        }
        return output;
    }

    public BufferedWriter saveToFileAsCSVMatrix(BufferedWriter bf, String delimiter) throws IOException {
        int j = 0;
        while (j < this.column_count) {
            bf.write("'" + this.columnNames[j] + "'");
            if (j < this.column_count - 1) {
                bf.write(delimiter);
            }
            ++j;
        }
        bf.write("\n");
        int i = 0;
        while (i < this.row_count) {
            j = 0;
            while (j < this.column_count) {
                bf.write(String.valueOf(this._data[i][j]));
                if (j < this.column_count - 1) {
                    bf.write(delimiter);
                }
                ++j;
            }
            bf.write("\n");
            ++i;
        }
        return bf;
    }

    public BufferedWriter saveToFileAsAdjacencyList(BufferedWriter bf, String delimiter) throws IOException {
        int i = 0;
        while (i < this.row_count) {
            String a = this.rowNames[i];
            int j = i + 1;
            while (j < this.column_count) {
                String b = this.columnNames[j];
                if (this._data[i][j] > 0.0) {
                    bf.write(a);
                    bf.write(delimiter);
                    bf.write(b);
                    bf.write(delimiter);
                    bf.write(String.valueOf((int)this._data[i][j]));
                    bf.write("\n");
                }
                ++j;
            }
            ++i;
        }
        return bf;
    }

    public int getRowIndex(String name) {
        if (this.rowNames == null) {
            return -1;
        }
        int i = 0;
        while (i < this.rowNames.length) {
            if (this.rowNames[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getColumnIndex(String name) {
        if (this.columnNames == null) {
            return -1;
        }
        int i = 0;
        while (i < this.columnNames.length) {
            if (this.columnNames[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Jama.Matrix getLaplacianMatrix() {
        int size = this.getColumnCount();
        double[][] data_copy = new double[size][size];
        int i = 0;
        while (i < size) {
            data_copy[i][i] = 0.0;
            int j = 0;
            while (j < size) {
                if (i != j) {
                    data_copy[i][j] = -this._data[i][j];
                    data_copy[j][i] = data_copy[i][j];
                    double[] dArray = data_copy[i];
                    int n = i;
                    dArray[n] = dArray[n] + this._data[i][j];
                }
                ++j;
            }
            ++i;
        }
        Jama.Matrix jamaM = new Jama.Matrix(data_copy, this.row_count, this.column_count);
        return jamaM;
    }

    public EigenvalueDecomposition getEigenDecomposition() {
        double[][] copy = new double[this.row_count][this.row_count];
        int i = 0;
        while (i < this.row_count) {
            int j = i;
            while (j < this.row_count) {
                double d = this._data[i][j];
                copy[j][i] = d;
                copy[i][j] = d;
                ++j;
            }
            ++i;
        }
        Jama.Matrix jamaM = new Jama.Matrix(copy, this.row_count, this.column_count);
        EigenvalueDecomposition ed = new EigenvalueDecomposition(jamaM);
        return ed;
    }

    public int getBandwidth() {
        int sum = 0;
        int i = 0;
        while (i < this.column_count - 1) {
            int j = this.column_count - 1;
            while (j > i) {
                if (this._data[i][j] > 0.0) {
                    sum += j - i;
                    break;
                }
                --j;
            }
            ++i;
        }
        return sum;
    }

    public static Matrix[] getConnectedComponents(Matrix m) {
        int size = m.row_count;
        HashSet<Integer> allVertices = new HashSet<Integer>();
        int i = 0;
        while (i < size) {
            allVertices.add(i);
            ++i;
        }
        HashSet<Integer> nodes_to_expand_now = new HashSet<Integer>();
        HashSet<Integer> nodes_to_expand_later = new HashSet<Integer>();
        HashSet<Integer> component_vertices = new HashSet<Integer>();
        ArrayList<Set<Integer>> vertex_sets = new ArrayList<Set<Integer>>();
        component_vertices.add(0);
        nodes_to_expand_now.add(0);
        HashSet<Integer> visited = new HashSet<Integer>();
        while (visited.size() < size) {
            Iterator iterator = nodes_to_expand_now.iterator();
            while (iterator.hasNext()) {
                int node_index = (Integer)iterator.next();
                i = 0;
                while (i < size) {
                    double value = m.getElement(node_index, i);
                    if (value > 0.0 && node_index != i && !component_vertices.contains(i)) {
                        nodes_to_expand_later.add(i);
                        component_vertices.add(i);
                    }
                    ++i;
                }
            }
            nodes_to_expand_now.clear();
            nodes_to_expand_now.addAll(nodes_to_expand_later);
            nodes_to_expand_later.clear();
            if (nodes_to_expand_now.size() != 0) continue;
            vertex_sets.add(new HashSet(component_vertices));
            visited.addAll(component_vertices);
            component_vertices.clear();
            HashSet<Integer> temp = new HashSet<Integer>();
            temp.addAll(allVertices);
            temp.removeAll(visited);
            if (temp.size() <= 0) continue;
            Iterator iterator2 = temp.iterator();
            nodes_to_expand_now.add((Integer)iterator2.next());
            component_vertices.addAll(nodes_to_expand_now);
        }
        return Matrix.componentsToMatrices(m, vertex_sets);
    }

    public static Matrix[] getConnectedComponents2(Matrix m) {
        HashSet<Integer> vertices = new HashSet<Integer>();
        HashSet<Integer> visited = new HashSet<Integer>();
        int i = 0;
        while (i < m.getColumnCount()) {
            vertices.add(i);
            ++i;
        }
        ArrayList<Set<Integer>> components = new ArrayList<Set<Integer>>();
        while (!vertices.isEmpty()) {
            Iterator iter = vertices.iterator();
            Integer v = (Integer)iter.next();
            HashSet<Integer> component = new HashSet<Integer>();
            components.add(component);
            HashSet<Integer> Q = new HashSet<Integer>();
            Q.add(v);
            component.add(v);
            visited.add(v);
            while (!Q.isEmpty()) {
                Iterator iterator = Q.iterator();
                Integer t = (Integer)iterator.next();
                Q.remove(t);
                int i2 = 0;
                while (i2 < m.getColumnCount()) {
                    int u;
                    int n = u = m.getElement(t, i2) > 0.0 ? i2 : -1;
                    if (u > 0 && !visited.contains(u)) {
                        visited.add(u);
                        Q.add(u);
                        component.add(u);
                    }
                    ++i2;
                }
            }
            vertices.removeAll(component);
        }
        return Matrix.componentsToMatrices(m, components);
    }

    private static Matrix[] componentsToMatrices(Matrix m, List<Set<Integer>> components2) {
        int size = components2.size();
        Matrix[] components = new Matrix[size];
        int i = 0;
        while (i < size) {
            Set<Integer> component = components2.get(i);
            int component_size = component.size();
            double[][] data = new double[component_size][component_size];
            String[] names = new String[component_size];
            int k = 0;
            for (int index1 : component) {
                int l = 0;
                names[k] = m.getRowName(index1);
                for (int index2 : component) {
                    double d = m.getElement(index1, index2);
                    data[l][k] = d;
                    data[k][l] = d;
                    ++l;
                }
                ++k;
            }
            components[i] = new Matrix(data, names, names);
            ++i;
        }
        return components;
    }

    public static Matrix mergeComponents(Matrix[] reorderedComponents, double max) {
        int smallSize;
        int bigSize = 0;
        Matrix[] matrixArray = reorderedComponents;
        int n = reorderedComponents.length;
        int n2 = 0;
        while (n2 < n) {
            Matrix m = matrixArray[n2];
            smallSize = m.row_count;
            bigSize += smallSize;
            ++n2;
        }
        double[][] data = new double[bigSize][bigSize];
        String[] names = new String[bigSize];
        int offset = 0;
        Matrix[] matrixArray2 = reorderedComponents;
        int n3 = reorderedComponents.length;
        int n4 = 0;
        while (n4 < n3) {
            Matrix m = matrixArray2[n4];
            smallSize = m.row_count;
            int i = 0;
            while (i < smallSize) {
                names[offset + i] = m.getRowName(i);
                int j = 0;
                while (j < smallSize) {
                    data[offset + i][offset + j] = m._data[i][j];
                    ++j;
                }
                ++i;
            }
            offset += smallSize;
            ++n4;
        }
        return new Matrix(data, names, names, max);
    }

    public static Matrix reorderSubMatrix(Matrix matrix, Matrix referenceMatrix) {
        if (matrix == null || referenceMatrix == null) {
            return null;
        }
        int rowCount = matrix.getRowCount();
        String[] names = new String[rowCount];
        double[][] data = new double[rowCount][rowCount];
        int i = 0;
        while (i < rowCount) {
            String rowName = referenceMatrix.getRowName(i);
            int oldRowIndex = matrix.getRowIndex(rowName);
            names[i] = rowName;
            int j = 0;
            while (j < rowCount) {
                String columnName = referenceMatrix.getColumnName(j);
                int oldColumnIndex = matrix.getColumnIndex(columnName);
                data[i][j] = matrix.getElement(oldRowIndex, oldColumnIndex);
                ++j;
            }
            ++i;
        }
        Matrix m = new Matrix(data, names, names, matrix.getMax());
        return m;
    }

    protected void setMax(double d) {
        this._maximum = d;
    }
}

