/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.data;

import edu.umd.coral.model.data.Named;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonScores<T extends Named> {
    private float[][] scores;
    private ArrayList<T> ordering;

    public ComparisonScores(float[][] scores, ArrayList<T> list) {
        this.scores = scores;
        this.ordering = list;
    }

    public float getValue(int i, int j) {
        return this.scores[i][j];
    }

    public T getXItem(int i) {
        return (T)((Named)this.ordering.get(i));
    }

    public T getYItem(int j) {
        return (T)((Named)this.ordering.get(j));
    }

    public int getSize() {
        return this.scores.length;
    }

    public float getMin() {
        float min = Float.MAX_VALUE;
        int size = this.scores.length;
        int i = 0;
        while (i < size) {
            int j = i + 1;
            while (j < size) {
                if (this.scores[i][j] < min) {
                    min = this.scores[i][j];
                }
                ++j;
            }
            ++i;
        }
        return min;
    }

    public float getMax() {
        float max = Float.MIN_VALUE;
        int size = this.scores.length;
        int i = 0;
        while (i < size) {
            int j = i + 1;
            while (j < size) {
                if (this.scores[i][j] > max) {
                    max = this.scores[i][j];
                }
                ++j;
            }
            ++i;
        }
        return max;
    }

    public float[][] getScores() {
        return this.scores;
    }

    public ArrayList<T> getGreedyOrdering() {
        ArrayList<Named> o = new ArrayList<Named>();
        HashSet<Integer> visited = new HashSet<Integer>();
        float max = Float.MIN_VALUE;
        int size = this.scores.length;
        int t1 = 0;
        int t2 = 0;
        int i = 0;
        while (i < size - 1) {
            int j = i + 1;
            while (j < size) {
                if (this.scores[i][j] > max) {
                    max = this.scores[i][j];
                    t1 = i;
                    t2 = j;
                }
                ++j;
            }
            ++i;
        }
        visited.add(t1);
        visited.add(t2);
        float t1Max = Float.MIN_VALUE;
        float t2Max = Float.MIN_VALUE;
        int index = -1;
        int index2 = -1;
        i = 0;
        while (i < size) {
            if (this.scores[t1][i] > t1Max && !visited.contains(i)) {
                t1Max = this.scores[t1][i];
                index = i;
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            if (this.scores[t2][i] > t2Max && !visited.contains(i)) {
                t2Max = this.scores[t2][i];
                index2 = i;
            }
            ++i;
        }
        if (size <= 2) {
            o.add((Named)this.ordering.get(t1));
            o.add((Named)this.ordering.get(t2));
            return o;
        }
        if (t1Max > t2Max) {
            o.add((Named)this.ordering.get(t2));
            o.add((Named)this.ordering.get(t1));
            o.add((Named)this.ordering.get(index));
        } else {
            o.add((Named)this.ordering.get(t1));
            o.add((Named)this.ordering.get(t2));
            o.add((Named)this.ordering.get(index2));
            index = index2;
        }
        visited.add(index2);
        while (o.size() < size) {
            max = Float.MIN_VALUE;
            i = 0;
            while (i < size) {
                if (this.scores[index][i] > max && !visited.contains(i)) {
                    max = this.scores[index][i];
                    index2 = i;
                }
                ++i;
            }
            visited.add(index2);
            o.add((Named)this.ordering.get(index2));
            index = index2;
        }
        return o;
    }

    public int getIndex(String s) {
        if (this.ordering == null) {
            return -1;
        }
        int size = this.ordering.size();
        int i = 0;
        while (i < size) {
            if (((Named)this.ordering.get(i)).getName().equals(s)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        if (this.ordering == null) {
            return "empty";
        }
        String s = "";
        int i = 0;
        while (i < this.ordering.size()) {
            s = String.valueOf(s) + ((Named)this.ordering.get(i)).getName();
            ++i;
        }
        return String.valueOf(s) + " scores: " + this.scores.toString();
    }
}

