/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model.data;

import edu.umd.coral.model.data.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Clique {
    private Map<String, Vertex> vertices;
    private ArrayList<Integer> indicies = new ArrayList();
    private double value = 0.0;

    public Clique() {
    }

    public Clique(Collection<Vertex> vis) {
        if (vis == null) {
            this.vertices = new HashMap<String, Vertex>();
        }
        for (Vertex v : vis) {
            this.vertices.put(v.getName(), v);
        }
    }

    public void addVertex(Vertex v) {
        if (this.vertices == null) {
            this.vertices = new HashMap<String, Vertex>();
        }
        this.vertices.put(v.getName(), v);
    }

    public boolean hasVertex(String name) {
        return this.vertices.containsKey(name);
    }

    public Collection<Vertex> getVertices() {
        return this.vertices.values();
    }

    public String getAggregateName() {
        if (this.vertices == null) {
            return "";
        }
        String str = "";
        for (String s : this.vertices.keySet()) {
            str = String.valueOf(str) + s + "_";
        }
        return str;
    }

    public String toString() {
        if (this.vertices == null) {
            return String.valueOf(this.value) + " " + this.indicies.toString();
        }
        return String.valueOf(this.vertices.size()) + " " + this.vertices.toString();
    }

    public int size() {
        if (this.vertices == null) {
            return 0;
        }
        return this.vertices.size();
    }

    public int getInEdges() {
        int count = 0;
        for (Vertex v : this.vertices.values()) {
            Collection<Vertex> neigh = v.getNeighbors();
            for (Vertex u : neigh) {
                if (!this.vertices.containsValue(u)) continue;
                ++count;
            }
        }
        return count / 2;
    }

    public int getOutEdges() {
        int count = 0;
        for (Vertex v : this.vertices.values()) {
            Collection<Vertex> neigh = v.getNeighbors();
            neigh.removeAll(this.vertices.values());
            count += neigh.size();
        }
        return count;
    }

    public void setQualityValue(double value) {
        this.value = value;
    }

    public double getQualityValue() {
        return this.value;
    }

    public void addName(String name) {
        if (this.vertices == null) {
            this.vertices = new HashMap<String, Vertex>();
        }
        this.vertices.put(name, null);
    }

    public void addIndex(int j) {
        this.indicies.add(j);
    }

    public ArrayList<Integer> getIndices() {
        return this.indicies;
    }
}

