/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model;

import java.awt.Color;

public class MatrixColorModel {
    public static final int[] COLORS = new int[]{0xFFFFD4, 16701838, 16685353, 14245646, 10040324};
    public static final int[] COLORS_DIVERGING = new int[]{1742928, 9555808, 16703627, 16551257, 14102567};
    public static final Color[] COLORS_DIVERGING_RGB = new Color[]{new Color(0), new Color(1742928), new Color(9555808), new Color(16703627), new Color(16551257), new Color(14102567)};

    public static Color getRGBColor(double value, double maxValue, boolean selected) {
        double saturation = 1.0;
        double brightness = 0.9f;
        double index = 120.0 - (value - 1.0) * (120.0 / (maxValue - 1.0));
        if (value == 0.0) {
            brightness = 0.0;
            saturation = 0.0;
        }
        if (maxValue == 1.0) {
            index = 120.0;
        }
        if (selected) {
            saturation = 0.7f;
            brightness = 1.0;
            if (value == 0.0) {
                value = 360.0;
                saturation = 0.2f;
                brightness = 1.0;
            }
        }
        Color c = Color.getHSBColor((float)index / 360.0f, (float)saturation, (float)brightness);
        return c;
    }

    public static Color getGrayScaleColor(double value, double maxValue) {
        double saturation = 0.0;
        double brightness = 0.9f;
        double index = 120.0 - (value - 1.0) * (120.0 / (maxValue - 1.0));
        if (value == 0.0) {
            brightness = 0.0;
            saturation = 0.0;
        }
        if (maxValue == 1.0) {
            index = 120.0;
        }
        Color c = Color.getHSBColor(0.0f, (float)saturation, (float)(brightness * index / 360.0));
        return c;
    }
}

