/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model;

import java.awt.Color;

public class GradientColorModel {
    public static final float MAX_SATURATION = 1.0f;
    public static final float MAX_BRIGHTNESS = 1.0f;
    public static final float EPSILON = 0.001f;

    public static Color getMatrixColor(double value, double maxValue, boolean selected) {
        float hue = 10.0f;
        return GradientColorModel.getRGBColor(value, maxValue, selected, hue);
    }

    public static Color getLadderColor(float value, float maxValue, boolean isSelected) {
        float hue = 210.0f;
        return GradientColorModel.getRGBColor(value, maxValue, isSelected, hue);
    }

    public static Color getRGBColor(double value, double maxValue, boolean selected, float hue) {
        double saturation = value / maxValue;
        if (value < (double)0.001f) {
            saturation = 0.001f;
        }
        float brightness = 1.0f;
        float index = hue;
        if (maxValue == value) {
            brightness = 1.0f;
            saturation = 1.0;
        }
        if (selected) {
            saturation = 0.7f;
            brightness = 1.0f;
        }
        Color c = Color.getHSBColor(index / 360.0f, (float)saturation, brightness);
        return c;
    }

    public static Color getGradientColor(Color c1, Color c2, float offset, boolean selected) {
        float ratio = offset;
        int red = (int)((float)c2.getRed() * ratio + (float)c1.getRed() * (1.0f - ratio));
        int green = (int)((float)c2.getGreen() * ratio + (float)c1.getGreen() * (1.0f - ratio));
        int blue = (int)((float)c2.getBlue() * ratio + (float)c1.getBlue() * (1.0f - ratio));
        Color color = new Color(red, green, blue);
        return color;
    }
}

