/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.model;

import edu.umd.coral.clustering.LapFasterReordering;
import edu.umd.coral.clustering.MatrixReordering;
import edu.umd.coral.managers.CliqueManager;
import edu.umd.coral.managers.FastDenseSubgraphFinder;
import edu.umd.coral.model.data.Clique;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.ComparisonScores;
import edu.umd.coral.model.data.Cooccurrence;
import edu.umd.coral.model.data.Edge;
import edu.umd.coral.model.data.Matrix;
import edu.umd.coral.model.data.Score;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.model.metrics.Metric;
import edu.umd.coral.model.metrics.MetricFactory;
import java.awt.Color;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import net.infonode.docking.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataModel
extends PropertyChangeSupport {
    private static final long serialVersionUID = 1L;
    public static final String ORIGINAL_MATRIX_CHANGED = "originalMatrixChanged";
    public static final String MATRIX_CHANGED = "currentMatrixChanged";
    public static final String CLUSTERINGS_CHANGED = "clusteringsChanged";
    public static final String VERTICES_CHANGED = "verticesChanged";
    public static final String VERTEX_PAIRS_CHANGED = "vertexPairsChanged";
    public static final String SELECTED_VERTICES_CHANGED = "selectedVerticesChanged";
    public static final String SELECTED_METRIC_CHANGED = "selectedMetricChanged";
    public static final String SELECTED_CLUSTERING_PAIR_CHANGED = "selectedClustPairChanged";
    public static final String METRIC_SCORES_CHANGED = "metricsScoresChanged";
    public static final String SELECTED_CLUSTERING_CHANGED = "selectedClusteringChanged";
    public static final String COOCCUR_CHANGED = "cooccurChanged";
    public static final String EDGES_CHANGED = "edgesChanged";
    public static final String BG_COLOR_CHANGED = "bgColorChanged";
    public static final String BOUND_CHANGED = "boundChanged";
    public static final String ZOOM_CHANGED = "zoomChanged";
    public static final String WEIGHT_RANGE_CHANGED = "weightRangeChanged";
    public static final String BOUNDRY_WEIGHT_CHANGED = "boundryWeightChanged";
    public static final String INTERNAL_CHANGED = "internalChanged";
    public static final String NETWORK_LOADED = "networkLoaded";
    public static final String CLUSTERING_ORDERING_CHANGED = "clusteringOrderingChanged";
    public static final String HIGHLIGHT_CLIQUES_CHANGED = "highlightCliquesChanged";
    public static final String OVERLAY_CLIQUES_CHANGED = "overlayCliques";
    public static final String CLIQUES_MATRIX_CHANGED = "cliquesChanged";
    public static final String SELECTION_MODE_CHANGED = "selectionModeChanged";
    public static final String DEFAULT_PATH_CHANGED = "defaultPathChanged";
    public static final String PROPERTIES = ".properties";
    public static final String SHOW_P_LABELS_CHANGED = "showPLabelsChanged";
    public static final String SHOW_P_ITEMS_CHANGED = "showPItemsChanged";
    public static final String VERTEX_TABLE_COLUMNS_CHANGED = "vertexTableColumnsChanged";
    public static final String MODULE_TABLE_COLUMNS_CHANGED = "moduleTableColumnsChanged";
    public static final String CLUSTERING_PP_ORDERING_CHANGED = "ppClusteringOrderingChanged";
    public static final String SEARCH_ITEM_CHANGED = "searchItemChanged";
    public static final String INITIAL_ORDER_SET = "initialOrderSet";
    public static final String INCLUDE_GRAB_BAG_CHANGED = "includeGrabBagChanged";
    public static final String MODULE_SPACING_CHANGED = "moduleSpacingChanged";
    private JFrame _appWindow;
    private Matrix originalMatrix = null;
    private Matrix _currentMatrix = null;
    private Map<String, Clustering> _clusterings = null;
    private Clustering _selectedClustering = null;
    private Map<String, Vertex> _vertices = null;
    private Map<Vertex, TreeMap<Vertex, Cooccurrence>> _vertexPairs = null;
    private ArrayList<String> _vertexTableColumns = null;
    private ArrayList<String> _moduleTableColumns = null;
    private Metric _selectedMetric = MetricFactory.getMetricInstance("Jaccard");
    private ArrayList<Vertex> _selectedVertices = null;
    private Score<Clustering> _selectedClusteringPair;
    private Map<String, ComparisonScores<Clustering>> _metric2Score = new HashMap<String, ComparisonScores<Clustering>>();
    private Collection<Edge<Vertex>> _edges = new ArrayList<Edge<Vertex>>();
    private boolean _hasEdges = false;
    private Color _backgroundColor = Color.BLACK;
    private int _lowerBound;
    private int _upperBound;
    private float _zoomValue = 1.0f;
    private boolean _isWeighted = false;
    private int _maxWeight;
    private int _minWeight;
    private int _highWeight;
    private int _lowWeight;
    private boolean _isInternal = false;
    private int greedyIter = 1;
    private int optIter;
    private MatrixReordering _reordering = new LapFasterReordering(this.greedyIter, this.optIter);
    private ArrayList<Clustering> _clustOrdering;
    private ArrayList<Clustering> _clustPPOrdering;
    private boolean _highlightCliques = false;
    private boolean _overlayCliques = false;
    private Collection<Clique> _cliqueMatrix;
    private CliqueManager _cliqueManager = new FastDenseSubgraphFinder();
    private String _selectionMode = "selectZoomRegion";
    private String _lastUsedPath;
    private boolean _showPLabels = true;
    private boolean _showPItems = true;
    private boolean _aggregateSingletons = true;
    private Clustering _baseClustering = null;
    private ArrayList<Vertex> _initialOrder;
    private final boolean debug = false;
    private View[] views;
    private Vertex searchItem;
    private boolean _includeGrabBag = false;
    private int _moduleSpacing = 5;

    public JFrame getMainWindow() {
        return this._appWindow;
    }

    public Matrix getOriginalMatrix() {
        return this.originalMatrix;
    }

    public void setOriginalMatrix(Matrix value) {
        Matrix oldValue = this.originalMatrix;
        this.originalMatrix = value;
        this.setHighlightCliques(false);
        this.setCliques(null);
        this.firePropertyChange(ORIGINAL_MATRIX_CHANGED, oldValue, this.originalMatrix);
    }

    public Matrix getCurrentMatrix() {
        return this._currentMatrix;
    }

    public void setCurrentMatrix(Matrix value) {
        Matrix oldValue = this._currentMatrix;
        this._currentMatrix = value;
        this.firePropertyChange(MATRIX_CHANGED, oldValue, this._currentMatrix);
    }

    public Map<String, Clustering> getClusterings() {
        return this._clusterings;
    }

    public void setClusterings(Map<String, Clustering> value) {
        Map<String, Clustering> oldValue = this._clusterings;
        this._clusterings = value;
        this.firePropertyChange(CLUSTERINGS_CHANGED, oldValue, this._clusterings);
    }

    public Clustering getSelectedClustering() {
        return this._selectedClustering;
    }

    public void setSelectedClustering(Clustering value) {
        Clustering oldValue = this._selectedClustering;
        this._selectedClustering = value;
        this.firePropertyChange(SELECTED_CLUSTERING_CHANGED, oldValue, this._selectedClustering);
    }

    public Map<String, Vertex> getVertices() {
        return this._vertices;
    }

    public void setVertices(Map<String, Vertex> value) {
        Map<String, Vertex> oldValue = this._vertices;
        this._vertices = value;
        this.firePropertyChange(VERTICES_CHANGED, oldValue, this._vertices);
    }

    public Map<Vertex, TreeMap<Vertex, Cooccurrence>> getVertexPairs() {
        return this._vertexPairs;
    }

    public void setVertexPairs(Map<Vertex, TreeMap<Vertex, Cooccurrence>> value) {
        Map<Vertex, TreeMap<Vertex, Cooccurrence>> oldValue = this._vertexPairs;
        this._vertexPairs = value;
        this.firePropertyChange(VERTEX_PAIRS_CHANGED, oldValue, this._vertexPairs);
    }

    public ArrayList<String> getVertexTableColumns() {
        return this._vertexTableColumns;
    }

    public void setVertexTableColumns(ArrayList<String> value) {
        ArrayList<String> oldValue = this._vertexTableColumns;
        this._vertexTableColumns = value;
        this.firePropertyChange(VERTEX_TABLE_COLUMNS_CHANGED, oldValue, this._vertexPairs);
    }

    public ArrayList<String> getModuleTableColumns() {
        return this._moduleTableColumns;
    }

    public void setModuleTableColumns(ArrayList<String> value) {
        ArrayList<String> oldValue = this._moduleTableColumns;
        this._moduleTableColumns = value;
        this.firePropertyChange(MODULE_TABLE_COLUMNS_CHANGED, oldValue, this._vertexPairs);
    }

    public Metric getSelectedMetric() {
        return this._selectedMetric;
    }

    public void setSelectedMetric(Metric value) {
        Metric oldValue = this._selectedMetric;
        this._selectedMetric = value;
        this.firePropertyChange(SELECTED_METRIC_CHANGED, oldValue, this._selectedMetric);
    }

    public ArrayList<Vertex> getSelectedVertices() {
        return this._selectedVertices;
    }

    public void setSelectedVertices(ArrayList<Vertex> pair) {
        ArrayList<Vertex> oldValue = this._selectedVertices;
        this._selectedVertices = pair;
        this.firePropertyChange(SELECTED_VERTICES_CHANGED, oldValue, this._selectedVertices);
    }

    public Score<Clustering> getSelectedClusteringPair() {
        return this._selectedClusteringPair;
    }

    public void setSelectedClusteringPair(Score<Clustering> value) {
        Score<Clustering> oldValue = this._selectedClusteringPair;
        this._selectedClusteringPair = value;
        this.firePropertyChange(SELECTED_CLUSTERING_PAIR_CHANGED, oldValue, this._selectedClusteringPair);
    }

    public ComparisonScores<Clustering> getScores(String value) {
        if (this._metric2Score != null) {
            return this._metric2Score.get(value);
        }
        return null;
    }

    public void addScores(Metric m, ComparisonScores<Clustering> value) {
        ComparisonScores<Clustering> oldValue;
        if (this._metric2Score == null) {
            oldValue = null;
            this._metric2Score = new HashMap<String, ComparisonScores<Clustering>>();
        } else {
            oldValue = this._metric2Score.get(m.getName());
            this._metric2Score.put(m.getName(), value);
        }
        this.firePropertyChange(METRIC_SCORES_CHANGED, oldValue, value);
    }

    public Collection<Edge<Vertex>> getEdges() {
        return this._edges;
    }

    public void setEdges(Collection<Edge<Vertex>> value) {
        Collection<Edge<Vertex>> oldValue = this._edges;
        this._edges = value;
        this.firePropertyChange(EDGES_CHANGED, oldValue, value);
    }

    public boolean hasEdges() {
        return this._hasEdges;
    }

    public void setHasEdges(boolean value) {
        boolean oldValue = this._hasEdges;
        this._hasEdges = value;
        this.firePropertyChange(EDGES_CHANGED, oldValue, value);
    }

    public Color getBackgroundColor() {
        return this._backgroundColor;
    }

    public void setBackgroundColor(Color value) {
        Color oldValue = this._backgroundColor;
        this._backgroundColor = value;
        this.firePropertyChange(BG_COLOR_CHANGED, oldValue, value);
    }

    public int getLowerBound() {
        return this._lowerBound;
    }

    public void setLowerBound(int value) {
        int oldValue = this._lowerBound;
        this._lowerBound = value;
        this.firePropertyChange(BOUND_CHANGED, oldValue, value);
    }

    public int getUpperBound() {
        return this._upperBound;
    }

    public void setUpperBound(int value) {
        int oldValue = this._upperBound;
        this._upperBound = value;
        this.firePropertyChange(BOUND_CHANGED, oldValue, value);
    }

    public float getZoomValue() {
        return this._zoomValue;
    }

    public void setZoomValue(float value) {
        if (value < 0.2f) {
            value = 0.2f;
        }
        if (value > 10.0f) {
            value = 10.0f;
        }
        float oldValue = this._zoomValue;
        this._zoomValue = value;
        this.firePropertyChange(ZOOM_CHANGED, Float.valueOf(oldValue), Float.valueOf(value));
    }

    public boolean isWeighted() {
        return this._isWeighted;
    }

    public void setWeighted(boolean isWeighted) {
        this._isWeighted = isWeighted;
    }

    public int getMaxWeight() {
        return this._maxWeight;
    }

    public void setMaxWeight(float value) {
        int oldValue = this._maxWeight;
        this._maxWeight = (int)Math.ceil(value);
        this.firePropertyChange(WEIGHT_RANGE_CHANGED, (Object)oldValue, Float.valueOf(value));
    }

    public int getMinWeight() {
        return this._minWeight;
    }

    public void setMinWeight(float value) {
        float oldValue = this._minWeight;
        this._minWeight = (int)Math.floor(value);
        this.firePropertyChange(WEIGHT_RANGE_CHANGED, Float.valueOf(oldValue), Float.valueOf(value));
    }

    public int getHighWeight() {
        return this._highWeight;
    }

    public void setHighWeight(int value) {
        int oldValue = this._highWeight;
        this._highWeight = value;
        this.firePropertyChange(BOUNDRY_WEIGHT_CHANGED, oldValue, value);
    }

    public int getLowWeight() {
        return this._lowWeight;
    }

    public void setLowWeight(int value) {
        float oldValue = this._lowWeight;
        this._lowWeight = value;
        this.firePropertyChange(BOUNDRY_WEIGHT_CHANGED, Float.valueOf(oldValue), (Object)value);
    }

    public boolean isInternal() {
        return this._isInternal;
    }

    public void setInternal(boolean isInternal) {
        this._isInternal = isInternal;
        this.firePropertyChange(INTERNAL_CHANGED, !isInternal, isInternal);
    }

    public int getMatrixGreedyIterations() {
        return this.greedyIter;
    }

    public void setMatrixGreedyIterations(int value) {
        this.greedyIter = value;
    }

    public int getMatrixOptIterations() {
        return this.optIter;
    }

    public void setMatrixOptIterations(int value) {
        this.optIter = value;
    }

    public MatrixReordering getReordering() {
        return this._reordering;
    }

    public ArrayList<Clustering> getClusteringOrdering() {
        return this._clustOrdering;
    }

    public void setClusteringOrdering(ArrayList<Clustering> value) {
        ArrayList<Clustering> oldValue = this._clustOrdering;
        this._clustOrdering = value;
        this.firePropertyChange(CLUSTERING_ORDERING_CHANGED, oldValue, value);
    }

    public ArrayList<Clustering> getPPClusteringOrdering() {
        return this._clustPPOrdering;
    }

    public void setPPClusteringOrdering(ArrayList<Clustering> value) {
        ArrayList<Clustering> oldValue = this._clustPPOrdering;
        this._clustPPOrdering = value;
        this.firePropertyChange(CLUSTERING_PP_ORDERING_CHANGED, oldValue, value);
    }

    public boolean getHighlightCliques() {
        return this._highlightCliques;
    }

    public void setHighlightCliques(boolean value) {
        boolean oldValue = this._highlightCliques;
        this._highlightCliques = value;
        this.firePropertyChange(HIGHLIGHT_CLIQUES_CHANGED, oldValue, value);
    }

    public boolean getOverlayCliques() {
        return this._overlayCliques;
    }

    public void setOverlayCliques(boolean value) {
        boolean oldValue = this._overlayCliques;
        this._overlayCliques = value;
        this.firePropertyChange(OVERLAY_CLIQUES_CHANGED, oldValue, value);
    }

    public Collection<Clique> getCliques() {
        return this._cliqueMatrix;
    }

    public void setCliques(Collection<Clique> value) {
        Collection<Clique> oldValue = this._cliqueMatrix;
        this._cliqueMatrix = value;
        this.firePropertyChange(CLIQUES_MATRIX_CHANGED, oldValue, this._cliqueMatrix);
    }

    public CliqueManager getCliqueManager() {
        return this._cliqueManager;
    }

    public String getSelectionMode() {
        return this._selectionMode;
    }

    public void setSelectionMode(String value) {
        String oldValue = this._selectionMode;
        this._selectionMode = value;
        this.firePropertyChange(SELECTION_MODE_CHANGED, oldValue, this._selectionMode);
    }

    public String getLastPath() {
        return this._lastUsedPath;
    }

    public void setLastPath(String value) {
        String oldValue = this._lastUsedPath;
        this._lastUsedPath = value;
        this.firePropertyChange(DEFAULT_PATH_CHANGED, oldValue, this._lastUsedPath);
    }

    public boolean getShowPLabels() {
        return this._showPLabels;
    }

    public void setShowPLabels(boolean value) {
        boolean oldVal = this._showPLabels;
        this._showPLabels = value;
        this.firePropertyChange(SHOW_P_LABELS_CHANGED, oldVal, value);
    }

    public boolean getShowPItems() {
        return this._showPItems;
    }

    public void setShowPItems(boolean value) {
        boolean oldVal = this._showPItems;
        this._showPItems = value;
        this.firePropertyChange(SHOW_P_ITEMS_CHANGED, oldVal, value);
    }

    public DataModel(JFrame c) {
        super(c);
        this._appWindow = c;
    }

    public void reset() {
        this._hasEdges = false;
        this._reordering = null;
        this.setOriginalMatrix(null);
        this.setCurrentMatrix(null);
        this.setClusterings(null);
        this._metric2Score.clear();
        this.setSelectedClustering(null);
        this.setSelectedMetric(MetricFactory.getMetricInstance("Jaccard"));
        this.setSelectedClusteringPair(null);
        this.setVertices(null);
        this.setSelectedVertices(null);
        this.setBackgroundColor(Color.BLACK);
        this.setInitialVertexOrder(null);
        this.setZoomValue(1.0f);
        this.setWeighted(false);
        this.setInternal(false);
        this.setEdges(null);
        this.setHighlightCliques(false);
        this.setOverlayCliques(false);
    }

    public void setAggregateSingletons(boolean p) {
        this._aggregateSingletons = p;
    }

    public boolean getAggregateSingletons() {
        return this._aggregateSingletons;
    }

    public void setBaseClustering(Clustering c) {
        this._baseClustering = c;
    }

    public Clustering getBaseClustering() {
        return this._baseClustering;
    }

    public ArrayList<Vertex> getInitialVertexOrder() {
        return this._initialOrder;
    }

    public void setInitialVertexOrder(ArrayList<Vertex> value) {
        ArrayList<Vertex> oldValue = this._initialOrder;
        this._initialOrder = value;
        this.firePropertyChange(INITIAL_ORDER_SET, oldValue, this._initialOrder);
    }

    public boolean isDebug() {
        return false;
    }

    public void setSearchString(String text) {
    }

    public View[] getViews() {
        return this.views;
    }

    public void setViews(View[] value) {
        this.views = value;
    }

    public Vertex getSearchItem() {
        return this.searchItem;
    }

    public void setSearchItem(Vertex value) {
        Vertex oldVal = this.searchItem;
        this.searchItem = value;
        this.firePropertyChange(SEARCH_ITEM_CHANGED, oldVal, value);
    }

    public boolean getIncludeGrabBag() {
        return this._includeGrabBag;
    }

    public int getModuleSpacing() {
        return this._moduleSpacing;
    }

    public void setModuleSpacing(int value) {
        int oldValue = this._moduleSpacing;
        this._moduleSpacing = value;
        this.firePropertyChange(MODULE_SPACING_CHANGED, oldValue, value);
    }
}

