/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.managers;

import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.ComparisonScores;
import edu.umd.coral.model.metrics.Metric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricScoreManager {
    private boolean includeGrabBag;

    public MetricScoreManager(boolean include) {
        this.includeGrabBag = include;
    }

    public ComparisonScores<Clustering> computeScores(Metric m, Collection<Clustering> clusterings) {
        if (m == null || clusterings == null) {
            return null;
        }
        ComparisonScores<Clustering> scores = this.calculateScores(m, new ArrayList<Clustering>(clusterings));
        return scores;
    }

    private ComparisonScores<Clustering> calculateScores(Metric metric, ArrayList<Clustering> clusterings) {
        System.out.println("Calculating similarity scores");
        Collections.sort(clusterings);
        int size = clusterings.size();
        float[][] data = new float[size][size];
        ArrayList<Clustering> list = new ArrayList<Clustering>();
        int i = 0;
        while (i < size - 1) {
            Clustering c1 = clusterings.get(i);
            list.add(c1);
            int j = i + 1;
            while (j < size) {
                try {
                    Clustering c2 = clusterings.get(j);
                    float f = metric.getScore(c1, c2, this.includeGrabBag);
                    data[i][j] = f;
                    data[j][i] = f;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++j;
            }
            ++i;
        }
        if (i < size) {
            list.add(clusterings.get(i));
        }
        return new ComparisonScores<Clustering>(data, list);
    }
}

