/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.managers;

import edu.umd.coral.managers.CliqueManager;
import edu.umd.coral.managers.Manager;
import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Clique;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Matrix;
import edu.umd.coral.model.data.MyMTJMatrix;
import edu.umd.coral.model.data.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixCollapseManager
extends Manager {
    public MatrixCollapseManager(DataModel m) {
        super(m);
    }

    @Override
    public void execute() {
        Matrix matrix = this.getModel().getCurrentMatrix();
        Map<String, Clustering> map = this.getModel().getClusterings();
        if (map == null) {
            return;
        }
        int max = map.size();
        Map<String, Vertex> vertices = this.getModel().getVertices();
        CliqueManager manager = this.getModel().getCliqueManager();
        long before = System.currentTimeMillis();
        ArrayList<Clique> cliques = manager.getCliques(matrix, false);
        for (Clique c : cliques) {
            for (int i : c.getIndices()) {
                String name = matrix.getColumnName(i);
                Vertex v = vertices.get(name);
                c.addVertex(v);
            }
        }
        long after = System.currentTimeMillis();
        System.out.println("Time to compute cliques: " + (after - before));
        if (this.getModel().getHighlightCliques()) {
            this.getModel().setCliques(cliques);
        } else {
            MyMTJMatrix collapsedMatrix = this.generateCollapsedMatrix(cliques, matrix, max);
            this.getModel().setCurrentMatrix(collapsedMatrix);
        }
    }

    private MyMTJMatrix generateCollapsedMatrix(ArrayList<Clique> cliques, Matrix matrix, int max) {
        int newSize = cliques.size();
        double[][] data = new double[newSize][newSize];
        String[] names = new String[newSize];
        int i = 0;
        while (i < newSize) {
            data[i][i] = max;
            Clique columnClq = cliques.get(i);
            names[i] = columnClq.getAggregateName();
            int j = 0;
            while (j < i) {
                Clique rowClq = cliques.get(j);
                float weight = this.computeEdgeWeight(rowClq, columnClq, matrix);
                data[j][i] = weight;
                data[i][j] = weight;
                ++j;
            }
            ++i;
        }
        return new MyMTJMatrix(data, names, names, (double)max);
    }

    private float computeEdgeWeight(Clique rowClique, Clique columnClique, Matrix m) {
        float weight = 0.0f;
        Collection<Vertex> rowVert = rowClique.getVertices();
        Collection<Vertex> colVert = columnClique.getVertices();
        for (Vertex u : rowVert) {
            int row = u.getIndex();
            for (Vertex v : colVert) {
                int column = v.getIndex();
                weight = (float)((double)weight + m.getElement(row, column));
            }
        }
        weight = weight / (float)rowVert.size() / (float)colVert.size();
        return weight;
    }
}

