/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.managers;

import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Cooccurrence;
import edu.umd.coral.model.data.Matrix;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.data.Vertex;
import edu.umd.coral.model.parse.FormatException;
import edu.umd.coral.model.parse.Parser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;

public class FileParserProgressDialog
extends JDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private JProgressBar progressBar;
    private JTextArea taskOutput;
    private Task task;
    private DataModel model;
    private String[] paths;

    public FileParserProgressDialog(DataModel model, String[] paths) {
        super(model.getMainWindow(), "Loading files", true);
        this.model = model;
        this.paths = paths;
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.progressBar, "First");
        panel.add((Component)new JScrollPane(this.taskOutput), "Center");
        this.setContentPane(panel);
        this.setDefaultCloseOperation(0);
        Point p = new Point(0, 0);
        Dimension d = model.getMainWindow().getSize();
        p.x = (int)(d.getWidth() - this.getPreferredSize().getWidth()) / 2;
        p.y = (int)(d.getHeight() - this.getPreferredSize().getHeight()) / 2;
        this.setLocation(p);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.task = new Task(model);
        this.task.addPropertyChangeListener(this);
        this.task.execute();
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setValue(progress);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Task
    extends SwingWorker<Matrix, Void> {
        public Task(DataModel model) {
        }

        @Override
        public Matrix doInBackground() throws Exception {
            this.setProgress(0);
            FileParserProgressDialog.this.taskOutput.append("Resetting the views...\n");
            FileParserProgressDialog.this.model.reset();
            this.setProgress(10);
            FileParserProgressDialog.this.taskOutput.append("Parsing input files...\n");
            ModuleFilesParser parser = new ModuleFilesParser();
            boolean hasOverlaps = parser.parse(FileParserProgressDialog.this.paths, FileParserProgressDialog.this.model, this, 10);
            this.setProgress(20);
            if (hasOverlaps) {
                FileParserProgressDialog.this.taskOutput.append("Overlapping modules: some comparison metrics may be scewed or inflated due to overlapping modules.\n");
            }
            FileParserProgressDialog.this.taskOutput.append("Creating a co-cluster matrix...\n");
            Matrix matrix = null;
            try {
                matrix = this.createCoclusterMatrix();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "Data loading error", 0);
            }
            this.setProgress(80);
            FileParserProgressDialog.this.model.setOriginalMatrix(matrix);
            FileParserProgressDialog.this.taskOutput.append("Updating parallel partitions plot...\n");
            this.setProgress(90);
            FileParserProgressDialog.this.model.setCurrentMatrix(matrix);
            this.setProgress(100);
            return matrix;
        }

        private Matrix createCoclusterMatrix() {
            int size = FileParserProgressDialog.this.model.getVertices().size();
            Matrix matrix = new Matrix(size, size);
            Map<Vertex, TreeMap<Vertex, Cooccurrence>> allCooccurr = null;
            Collection<Clustering> set = FileParserProgressDialog.this.model.getClusterings().values();
            int clustCount = set.size();
            int done = 0;
            for (Clustering c : set) {
                HashMap<Vertex, TreeMap<Vertex, Cooccurrence>> hashMap = c.createCooccurenceMatrix(FileParserProgressDialog.this.model.getInitialVertexOrder());
                this.setProgress((int)Math.floor(20.0 + 40.0 * (double)(++done) / (double)clustCount));
                allCooccurr = this.mergeInto(allCooccurr, hashMap);
                if (c.getCoocurenceMatrix().getColumnCount() != size) continue;
                matrix = matrix.addMatrix(c.getCoocurenceMatrix());
            }
            FileParserProgressDialog.this.taskOutput.append("Added co-cluster matrices\n");
            FileParserProgressDialog.this.taskOutput.append("Calculating co-cluster signatures...\n");
            Set keys = allCooccurr.keySet();
            for (Vertex u : keys) {
                Collection entries = ((TreeMap)allCooccurr.get(u)).values();
                for (Cooccurrence cooccur : entries) {
                    cooccur.setSignature(FileParserProgressDialog.this.model.getClusteringOrdering());
                }
            }
            FileParserProgressDialog.this.taskOutput.append("Updating pairs table...\n");
            FileParserProgressDialog.this.model.setVertexPairs(allCooccurr);
            this.setProgress(70);
            return matrix;
        }

        private Map<Vertex, TreeMap<Vertex, Cooccurrence>> mergeInto(Map<Vertex, TreeMap<Vertex, Cooccurrence>> allCooccurr, Map<Vertex, TreeMap<Vertex, Cooccurrence>> hashMap) {
            if (allCooccurr == null) {
                return hashMap;
            }
            for (Vertex u : hashMap.keySet()) {
                TreeMap<Vertex, Cooccurrence> newEntries = hashMap.get(u);
                TreeMap<Vertex, Cooccurrence> allMap = allCooccurr.get(u);
                if (allMap == null) {
                    allCooccurr.put(u, newEntries);
                    continue;
                }
                for (Vertex v : newEntries.keySet()) {
                    Cooccurrence cooccur = allMap.get(v);
                    if (cooccur == null) {
                        allMap.put(v, newEntries.get(v));
                        continue;
                    }
                    Set<Clustering> set = newEntries.get(v).getClusterings();
                    cooccur.addClusterings(set);
                }
            }
            return allCooccurr;
        }

        @Override
        public void done() {
            boolean gotException = true;
            Throwable cause = null;
            try {
                this.get();
                gotException = false;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                cause = e.getCause();
            }
            FileParserProgressDialog.this.setCursor(null);
            FileParserProgressDialog.this.progressBar.setIndeterminate(false);
            if (!gotException) {
                FileParserProgressDialog.this.taskOutput.append("Done!\n");
                FileParserProgressDialog.this.setVisible(false);
                FileParserProgressDialog.this.dispose();
            } else {
                String msg = "Could not complete calculation. Parsing will abort.";
                String addlMsg = "";
                if (cause instanceof OutOfMemoryError) {
                    addlMsg = "\nTry increasing the default Java heap size.";
                }
                FileParserProgressDialog.this.taskOutput.append(msg);
                JOptionPane.showMessageDialog(null, String.valueOf(msg) + "\nCause:  " + cause.toString() + addlMsg);
                FileParserProgressDialog.this.model.reset();
                FileParserProgressDialog.this.dispose();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ModuleFilesParser
        extends Parser {
            public static final String GRAB_BAG = "__misc__";
            public final Color[] band_colors = new Color[]{new Color(141, 211, 199), new Color(254, 224, 144), new Color(190, 186, 218), new Color(128, 177, 211), new Color(253, 180, 98), new Color(179, 222, 105), new Color(252, 205, 229), new Color(217, 217, 217), new Color(191, 129, 45), new Color(128, 205, 193), new Color(53, 151, 143), new Color(254, 178, 76), new Color(128, 115, 172), new Color(178, 171, 210), new Color(224, 130, 20), new Color(90, 174, 97), new Color(27, 120, 55), new Color(153, 112, 171)};

            private ModuleFilesParser() {
            }

            public Color getColor(int i) {
                return this.band_colors[i % this.band_colors.length];
            }

            public boolean parse(String[] fileNames, DataModel model, Task worker, int prevProgress) throws Exception {
                long timeBefore = System.currentTimeMillis();
                ArrayList<Vertex> initialOrder = new ArrayList<Vertex>();
                boolean hasOverlapping = false;
                this.vertexIndex = 0;
                try {
                    String clusteringName;
                    int i = 0;
                    while (i < fileNames.length) {
                        String line;
                        this.vertexCount = 0;
                        File f = new File(fileNames[i]);
                        InputStreamReader fis = new InputStreamReader(new FileInputStream(f));
                        BufferedReader br = new BufferedReader(fis);
                        clusteringName = f.getName().endsWith(".txt") ? f.getName().replace(".txt", "") : (f.getName().endsWith(".clust") ? f.getName().replace(".clust", "") : f.getName());
                        Clustering c = new Clustering(clusteringName);
                        c.setColor(this.getColor(i));
                        this.clusterings.put(clusteringName, c);
                        while ((line = br.readLine()) != null) {
                            line = line.trim();
                            this.parseModule(c, line, initialOrder);
                        }
                        if (c.hasOverlap()) {
                            hasOverlapping = true;
                        }
                        worker.setProgress(prevProgress + (int)(10.0 * (double)i / (double)fileNames.length));
                        c.setOriginalVertexCount(this.vertexCount);
                        br.close();
                        fis.close();
                        ++i;
                    }
                    if (model.getAggregateSingletons()) {
                        for (Clustering clustering : this.clusterings.values()) {
                            clustering.recordOriginalModuleCount();
                            clusteringName = clustering.getName();
                            Module module = new Module(GRAB_BAG, clustering);
                            for (Vertex u : this.vertices.values()) {
                                if (clustering.hasVertex(u)) continue;
                                module.addVertex(u);
                            }
                            if (module.getSize() <= 0) continue;
                            clustering.addModule(module);
                        }
                    } else {
                        for (Clustering clustering : this.clusterings.values()) {
                            clustering.recordOriginalModuleCount();
                            clusteringName = clustering.getName();
                            for (Vertex u : this.vertices.values()) {
                                if (clustering.hasVertex(u)) continue;
                                String vertexName = u.getName();
                                Module module = new Module(String.valueOf(vertexName) + "_singl", true, clustering);
                                module.addVertex(u);
                                clustering.addModule(module);
                            }
                        }
                    }
                    model.setInitialVertexOrder(initialOrder);
                    model.setVertices(this.vertices);
                    model.setClusterings(this.clusterings);
                    ArrayList<Clustering> ordering = new ArrayList<Clustering>(this.clusterings.values());
                    Collections.sort(ordering);
                    model.setClusteringOrdering(ordering);
                    model.firePropertyChange("networkLoaded", false, true);
                    if (model.isDebug()) {
                        long timeAfter = System.currentTimeMillis();
                        System.out.println("FILEWORKER: Time to load data: " + (timeAfter - timeBefore) + "ms");
                    }
                }
                catch (FileNotFoundException e) {
                    System.out.println("File not found");
                    e.printStackTrace();
                }
                catch (IOException e2) {
                    System.out.println("IOException");
                    e2.printStackTrace();
                }
                catch (NullPointerException e3) {
                    System.out.println("null pointer");
                    e3.printStackTrace();
                }
                return hasOverlapping;
            }

            private void parseModule(Clustering c, String line, ArrayList<Vertex> initialOrder) throws Exception {
                String[] columns = line.split("[ \t\b\n\f\r]");
                if (columns.length < 2) {
                    System.out.println("Module line too short: " + line);
                    throw new FormatException(c.getName(), "", line);
                }
                String moduleName = columns[0].trim();
                Module module = new Module(moduleName, c);
                int j = 1;
                while (j < columns.length) {
                    Vertex v;
                    String vertexName = columns[j].trim();
                    if (this.vertices.containsKey(vertexName)) {
                        v = (Vertex)this.vertices.get(vertexName);
                        if (!c.containsVertex(v)) {
                            ++this.vertexCount;
                        }
                    } else {
                        v = new Vertex(vertexName, this.vertexIndex);
                        this.vertices.put(vertexName, v);
                        ++this.vertexIndex;
                        ++this.vertexCount;
                        initialOrder.add(v);
                    }
                    module.addVertex(v);
                    ++j;
                }
                c.addModule(module);
            }
        }
    }
}

