/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.managers;

import edu.umd.coral.managers.ModuleOrderManager;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Module;
import edu.umd.coral.model.data.Pair;
import edu.umd.coral.model.data.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossOverModuleOrderManager
extends ModuleOrderManager {
    @Override
    public ArrayList<Module> getOrdering(Clustering clustering, String[] names, int sizeCutoff) {
        return this.getModuleOrderings(clustering, names, sizeCutoff);
    }

    private ArrayList<Module> getModuleOrderings(Clustering c, String[] vertexNames, int sizeCutoff) {
        ArrayList l;
        if (c == null || vertexNames == null) {
            return null;
        }
        int size = vertexNames.length;
        HashMap<Module, Integer> mapping = new HashMap<Module, Integer>();
        HashMap<Module, ArrayList> vertexMapping = new HashMap<Module, ArrayList>();
        int i = 0;
        while (i < size) {
            Vertex v = c.getVertex(vertexNames[i]);
            Collection<Module> matchedModules = c.getVertexModule(v);
            for (Module module : matchedModules) {
                if (module.getSize() < sizeCutoff) continue;
                Pair<Vertex, Integer> p = new Pair<Vertex, Integer>(v, i);
                if (mapping.containsKey(module)) {
                    mapping.put(module, (Integer)mapping.get(module) + i);
                    l = (ArrayList)vertexMapping.get(module);
                } else {
                    mapping.put(module, i);
                    l = new ArrayList();
                    vertexMapping.put(module, l);
                }
                l.add(p);
            }
            ++i;
        }
        for (Map.Entry entry : vertexMapping.entrySet()) {
            Module module;
            l = (ArrayList)entry.getValue();
            module = (Module)entry.getKey();
            if (l.size() != module.getSize()) {
                System.out.println("I am going to fail soon...");
            }
            Collections.sort(l, new ModuleOrderManager.PairComparator(this));
            module.setVertexMapping(l);
        }
        ArrayList list = new ArrayList();
        list.addAll(mapping.entrySet());
        Collections.sort(list, new ModuleOrderManager.EntryComparator(this));
        ArrayList<Module> order = new ArrayList<Module>();
        for (Map.Entry entry : list) {
            order.add((Module)entry.getKey());
        }
        return order;
    }
}

