/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.managers;

import edu.umd.coral.managers.IManager;
import edu.umd.coral.model.DataModel;
import edu.umd.coral.model.data.Clustering;
import edu.umd.coral.model.data.Cooccurrence;
import edu.umd.coral.model.data.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteringOrderingManager
implements IManager {
    private DataModel _dataModel;

    public ClusteringOrderingManager(DataModel model) {
        this._dataModel = model;
    }

    @Override
    public void execute() {
        ArrayList<Clustering> sortedClusterings = this._dataModel.getClusteringOrdering();
        Map<Vertex, TreeMap<Vertex, Cooccurrence>> allCooccurr = this._dataModel.getVertexPairs();
        this.fixSignatures(allCooccurr, sortedClusterings);
        this._dataModel.setVertexPairs(allCooccurr);
    }

    private void fixSignatures(Map<Vertex, TreeMap<Vertex, Cooccurrence>> allCooccurr, List<Clustering> clusterings) {
        Set<Vertex> keys = allCooccurr.keySet();
        for (Vertex u : keys) {
            Collection<Cooccurrence> entries = allCooccurr.get(u).values();
            for (Cooccurrence cooccur : entries) {
                cooccur.setSignature(clusterings);
            }
        }
    }
}

