/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.clustering;

import edu.umd.coral.clustering.GreedyLAP;
import edu.umd.coral.clustering.MatrixReordering;
import edu.umd.coral.model.data.Matrix;
import java.util.ArrayList;
import javaasp.LinearAssignmentSolverMTJ;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import no.uib.cipr.matrix.sparse.SparseVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LapFasterReordering
implements MatrixReordering {
    private final String INDENT = "   ";
    private int greedyIterCount = 1;
    private int totalIterCount = 1;

    public LapFasterReordering(int greedyIter, int optIter) {
        this.greedyIterCount = greedyIter;
        this.totalIterCount = greedyIter + optIter;
    }

    @Override
    public Matrix reorder(Matrix originalMatrix) {
        System.out.println("reordering a matrix");
        Matrix[] components = Matrix.getConnectedComponents2(originalMatrix);
        System.out.println("found connected components " + components.length);
        int size = components.length;
        Matrix[] reorderedComponents = new Matrix[size];
        int i = 0;
        Matrix[] matrixArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Matrix m = matrixArray[n2];
            reorderedComponents[i] = this.reorderConnectedMatrix(m);
            ++i;
            ++n2;
        }
        Matrix matrix = Matrix.mergeComponents(reorderedComponents, originalMatrix.getMax());
        return matrix;
    }

    private Matrix reorderConnectedMatrix(Matrix m) {
        LapFasterReordering.print("*******************");
        System.out.println("   Reordering component of size " + m.getColumnCount());
        int size = m.getColumnCount();
        DenseMatrix weightM = this.createWeightMatrix(size);
        boolean has_improvements = true;
        ArrayList<String[]> prevOrders = new ArrayList<String[]>();
        prevOrders.add(new String[size]);
        int i = 0;
        while (i < size) {
            ((String[])prevOrders.get((int)0))[i] = String.valueOf(i);
            ++i;
        }
        String[] newRowOrder = new String[size];
        int[] newIntRowOrder = new int[size];
        int[] newIntColOrder = new int[size];
        int iter = 0;
        FlexCompRowMatrix M = this.getSparseMatrix(m);
        M.compact();
        FlexCompRowMatrix cost = new FlexCompRowMatrix(size, size);
        LinearAssignmentSolverMTJ las = new LinearAssignmentSolverMTJ();
        GreedyLAP greedy = new GreedyLAP();
        while (iter < this.totalIterCount && has_improvements) {
            has_improvements = false;
            long b4 = System.currentTimeMillis();
            FlexCompRowMatrix MT = (FlexCompRowMatrix)M.copy();
            this.mult(MT, weightM, cost);
            if (iter < this.greedyIterCount) {
                LapFasterReordering.print("   Doing stuff at GREEDY " + iter + " iteration");
                greedy.solve(size, cost, newIntColOrder, newIntRowOrder);
            } else {
                LapFasterReordering.print("   Doing stuff at OPT " + iter + " iteration");
                las.solve(size, cost, newIntColOrder, newIntRowOrder);
            }
            newRowOrder = this.translate(newIntRowOrder, (String[])prevOrders.get(prevOrders.size() - 1));
            if (this.different(newRowOrder, prevOrders)) {
                prevOrders.add(newRowOrder);
                has_improvements = true;
                M = this.robSwap(M, newIntRowOrder);
            }
            long after = System.currentTimeMillis();
            LapFasterReordering.print("   Iteration took " + (after - b4) + "ms");
            ++iter;
        }
        String[] col_names = new String[size];
        String[] lastOrder = (String[])prevOrders.get(prevOrders.size() - 1);
        int i2 = 0;
        while (i2 < size) {
            col_names[i2] = m.getColumnName(Integer.parseInt(lastOrder[i2]));
            ++i2;
        }
        Matrix reordered = new Matrix(M, col_names, (String[])col_names.clone());
        return reordered;
    }

    private void mult(FlexCompRowMatrix mT, DenseMatrix weightM, FlexCompRowMatrix cost) {
        long before = System.currentTimeMillis();
        int size = mT.numRows();
        double sum = 0.0;
        int i = 0;
        while (i < size) {
            SparseVector row = mT.getRow(i);
            int j = 0;
            while (j < size) {
                sum = 0.0;
                for (VectorEntry ve : row) {
                    sum += ve.get() * weightM.get(j, ve.index());
                }
                cost.set(i, j, sum);
                ++j;
            }
            ++i;
        }
        long after = System.currentTimeMillis();
        LapFasterReordering.print("   Matrix mult: " + (after - before) + "ms");
    }

    private FlexCompRowMatrix getSparseMatrix(Matrix m) {
        int size = m.getRowCount();
        FlexCompRowMatrix M = new FlexCompRowMatrix(size, size);
        int i = 0;
        while (i < size) {
            M.setRow(i, new SparseVector((Vector)new DenseVector(m.getRow(i))));
            ++i;
        }
        M.compact();
        return M;
    }

    private String[] translate(int[] newIntRowOrder, String[] strings) {
        int N = strings.length;
        String[] newRowOrder = new String[N];
        int i = 0;
        while (i < N) {
            newRowOrder[i] = strings[newIntRowOrder[i]];
            ++i;
        }
        return newRowOrder;
    }

    private boolean different(String[] newRowOrder, ArrayList<String[]> prevOrders) {
        int N = newRowOrder.length;
        int K = prevOrders.size();
        int diff = 0;
        int i = 0;
        while (i < K) {
            int j = 0;
            while (j < N) {
                if (!newRowOrder[j].equals(prevOrders.get(i)[j])) {
                    ++diff;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return diff == K;
    }

    private FlexCompRowMatrix robSwap(FlexCompRowMatrix m, int[] ranks) {
        int size = ranks.length;
        FlexCompRowMatrix temp = new FlexCompRowMatrix(size, size);
        int i = 0;
        while (i < size) {
            int oldRowIndex = ranks[i];
            DenseVector dense = new DenseVector(size);
            int j = 0;
            while (j < size) {
                int oldColumnIndex = ranks[j];
                dense.set(j, m.get(oldRowIndex, oldColumnIndex));
                ++j;
            }
            temp.setRow(i, new SparseVector((Vector)dense));
            ++i;
        }
        return temp;
    }

    private DenseMatrix createWeightMatrix(int N) {
        double[][] W = new double[N][N];
        int i = 0;
        while (i < N) {
            int j = i;
            while (j < N) {
                double d = Math.abs(i - j);
                W[j][i] = d;
                W[i][j] = d;
                ++j;
            }
            ++i;
        }
        return new DenseMatrix(W);
    }

    private static void print(String s) {
        System.out.println(s);
    }

    public void setIterations(int greedy, int opt) {
        this.greedyIterCount = greedy;
        this.totalIterCount = greedy + opt;
    }
}

