/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.clustering;

import edu.umd.coral.clustering.GreedyLAP;
import edu.umd.coral.clustering.ReorderingProgressDialog;
import edu.umd.coral.model.data.BaseMatrix;
import edu.umd.coral.model.data.Matrix;
import edu.umd.coral.model.data.MyMTJMatrix;
import java.util.ArrayList;
import javaasp.LinearAssignmentSolverMTJ;
import javax.swing.SwingWorker;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;
import no.uib.cipr.matrix.sparse.SparseVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LAPSwingWorker
extends SwingWorker<Matrix, Void> {
    private final String INDENT = "   ";
    private Matrix matrix2Reorder;
    private ReorderingProgressDialog parent;
    private int greedyIterCount = 1;
    private int totalIterCount = 1;
    private Matrix originalMatrix;

    public LAPSwingWorker(Matrix matrix, ReorderingProgressDialog parent, int greedyIter, int optIter) {
        this.originalMatrix = matrix;
        if (matrix instanceof BaseMatrix) {
            BaseMatrix base = (BaseMatrix)matrix;
            this.matrix2Reorder = base.getBaseMatrix();
        } else {
            this.matrix2Reorder = matrix;
        }
        this.parent = parent;
        this.greedyIterCount = greedyIter;
        this.totalIterCount = greedyIter + optIter;
    }

    @Override
    public Matrix doInBackground() throws Exception {
        int GET_CC = 2;
        int MERGE_CC = 2;
        this.parent.taskOutput.append("Computing connected components...\n");
        long startMillis = System.currentTimeMillis();
        System.out.println("current time: " + (System.currentTimeMillis() - startMillis));
        this.setProgress(0);
        Matrix[] components = Matrix.getConnectedComponents2(this.matrix2Reorder);
        this.setProgress(2);
        this.parent.taskOutput.append("Found " + components.length + " components\n");
        System.out.println("current time: " + (System.currentTimeMillis() - startMillis));
        int size = components.length;
        Matrix[] reorderedComponents = new Matrix[size];
        long sizeCubed = 0L;
        int n = 0;
        Matrix[] matrixArray = components;
        int n2 = components.length;
        int n3 = 0;
        while (n3 < n2) {
            Matrix m = matrixArray[n3];
            n = m.getColumnCount();
            LAPSwingWorker.print("Sizes " + n);
            sizeCubed = (long)((double)sizeCubed + Math.pow(n, 3.0));
            ++n3;
        }
        LAPSwingWorker.print("All sizes ^3 : " + sizeCubed);
        int i = 0;
        int accumProgress = 0;
        Matrix[] matrixArray2 = components;
        int n4 = components.length;
        int n5 = 0;
        while (n5 < n4) {
            Matrix m = matrixArray2[n5];
            n = m.getColumnCount();
            if (n > 3) {
                this.parent.taskOutput.append("Reordering component, size " + n + "...\n");
                LAPSwingWorker.print("96 " + Math.pow(n, 3.0) + " " + sizeCubed);
                double ratio = 96.0 * Math.pow(n, 3.0) / (double)sizeCubed;
                reorderedComponents[i] = this.reorderConnectedMatrix(m, 2 + accumProgress, ratio);
                LAPSwingWorker.print(Double.toString(96.0 * Math.pow(n, 3.0) / (double)sizeCubed));
                accumProgress = (int)((double)accumProgress + Math.floor(96.0 * Math.pow(n, 3.0) / (double)sizeCubed));
                this.setProgress(2 + accumProgress);
            } else {
                this.parent.taskOutput.append("Skipping component\n");
                reorderedComponents[i] = m;
            }
            ++i;
            ++n5;
        }
        System.out.println("reordered connected components ");
        System.out.println("total time to reorder conn comp: " + (System.currentTimeMillis() - startMillis));
        this.parent.taskOutput.append("Merging reordered components...\n");
        Matrix reorderedMatrix = Matrix.mergeComponents(reorderedComponents, this.matrix2Reorder.getMax());
        this.setProgress(100);
        this.parent.taskOutput.append("Merged\n");
        System.out.println("merged components ");
        System.out.println("current time: " + (System.currentTimeMillis() - startMillis));
        long endMillies = System.currentTimeMillis();
        System.out.println("total time to reorder: " + (endMillies - startMillis));
        if (this.originalMatrix instanceof BaseMatrix) {
            BaseMatrix originalBase = (BaseMatrix)this.originalMatrix;
            int N = reorderedMatrix.getColumnCount();
            double[][] data = new double[N][N];
            i = 0;
            while (i < N) {
                int j = i;
                while (j < N) {
                    double d = reorderedMatrix.getElement(i, j);
                    data[j][i] = d;
                    data[i][j] = d;
                    ++j;
                }
                ++i;
            }
            MyMTJMatrix copy = new MyMTJMatrix(data, reorderedMatrix.rowNames, reorderedMatrix.columnNames, reorderedMatrix.getMax());
            reorderedMatrix = new BaseMatrix(MyMTJMatrix.reorderSubMatrix(originalBase.getDataMatrix(), reorderedMatrix), copy);
        }
        return reorderedMatrix;
    }

    @Override
    public void done() {
        this.parent.taskOutput.append("Done.");
        this.parent.setCursor(null);
    }

    /*
     * Unable to fully structure code
     */
    private Matrix reorderConnectedMatrix(Matrix m, int prevProgress, double ratio) {
        LAPSwingWorker.print("*******************");
        System.out.println("   Reordering component of size " + m.getColumnCount());
        size = m.getColumnCount();
        this.parent.taskOutput.append("   Computing weight matrix...\n");
        weightM = this.createWeightMatrix(size);
        has_improvements = true;
        prevOrders = new ArrayList<String[]>();
        prevOrders.add(new String[size]);
        i = 0;
        while (i < size) {
            ((String[])prevOrders.get((int)0))[i] = String.valueOf(i);
            ++i;
        }
        newRowOrder = new String[size];
        newIntRowOrder = new int[size];
        newIntColOrder = new int[size];
        iter = 0;
        M = this.getSparseMatrix(m);
        M.compact();
        cost = new FlexCompRowMatrix(size, size);
        las = new LinearAssignmentSolverMTJ();
        greedy = new GreedyLAP();
        perIteration = ratio / (double)this.totalIterCount;
        LAPSwingWorker.print("Ratio " + ratio + " Per iter: " + perIteration + " totalIter " + this.totalIterCount);
        GR_MULT = 0.67f;
        GR_LAP = 0.08f;
        GR_REARR = 0.24f;
        OPT_MULT = 0.57f;
        OPT_LAP = 0.24f;
        OPT_REARR = 0.18f;
        did_greedy = false;
        if (!this.isCancelled()) ** GOTO lbl79
        return null;
lbl-1000:
        // 1 sources

        {
            has_improvements = false;
            b4 = System.currentTimeMillis();
            MT = (FlexCompRowMatrix)M.copy();
            this.parent.taskOutput.append("   Multipling matrices...\n");
            this.mult(MT, weightM, cost, prevProgress, 0.6700000166893005 * perIteration);
            if (this.isCancelled()) {
                return null;
            }
            if (iter < this.greedyIterCount) {
                prevProgress = (int)((double)prevProgress + Math.floor(perIteration * 0.6700000166893005));
                this.setProgress(prevProgress);
                this.parent.taskOutput.append("   Solving LAP using greedy heuristic, iteration " + iter + "...\n");
                LAPSwingWorker.print("   Doing stuff at GREEDY " + iter + " iteration");
                greedy.solve(size, cost, newIntColOrder, newIntRowOrder);
                prevProgress = (int)((double)prevProgress + Math.floor(perIteration * 0.07999999821186066));
                this.setProgress(prevProgress);
                did_greedy = true;
            } else {
                this.parent.taskOutput.append("   Solving LAP using Hungarian, iteration " + iter + "...\n");
                LAPSwingWorker.print("   Doing stuff at OPT " + iter + " iteration");
                prevProgress = (int)((double)prevProgress + Math.floor(perIteration * 0.5699999928474426));
                this.setProgress(prevProgress);
                beforeOpt = System.currentTimeMillis();
                las.solve(size, cost, newIntColOrder, newIntRowOrder);
                prevProgress = (int)((double)prevProgress + Math.floor(perIteration * 0.23999999463558197));
                this.setProgress(prevProgress);
                afterOpt = System.currentTimeMillis();
                System.out.println("      opt iteration: " + (afterOpt - beforeOpt));
                did_greedy = false;
            }
            if (this.isCancelled()) {
                return null;
            }
            this.parent.taskOutput.append("   Rearranging rows and columns...\n");
            newRowOrder = this.translate(newIntRowOrder, (String[])prevOrders.get(prevOrders.size() - 1));
            if (this.different(newRowOrder, prevOrders)) {
                prevOrders.add(newRowOrder);
                has_improvements = true;
                M = this.robSwap(M, newIntRowOrder);
                prevProgress = did_greedy != false ? (int)((double)prevProgress + Math.floor(perIteration * 0.23999999463558197)) : (int)((double)prevProgress + Math.floor(perIteration * 0.18000000715255737));
                this.setProgress(prevProgress);
            }
            if (this.isCancelled()) {
                return null;
            }
            after = System.currentTimeMillis();
            LAPSwingWorker.print("   Iteration took " + (after - b4) + "ms");
            ++iter;
lbl79:
            // 2 sources

            ** while (iter < this.totalIterCount && has_improvements)
        }
lbl80:
        // 1 sources

        col_names = new String[size];
        lastOrder = (String[])prevOrders.get(prevOrders.size() - 1);
        i = 0;
        while (i < size) {
            col_names[i] = m.getColumnName(Integer.parseInt(lastOrder[i]));
            ++i;
        }
        this.parent.taskOutput.append("   Finalizing reordering\n");
        reordered = new Matrix(M, col_names, (String[])col_names.clone());
        return reordered;
    }

    private void mult(FlexCompRowMatrix mT, DenseMatrix weightM, FlexCompRowMatrix cost, double prevProgress, double ratio) {
        long before = System.currentTimeMillis();
        int size = mT.numRows();
        double sum = 0.0;
        double perIter = ratio / (double)(size * size);
        LAPSwingWorker.print("Per iter mult " + perIter);
        int i = 0;
        while (i < size) {
            SparseVector row = mT.getRow(i);
            int j = 0;
            while (j < size) {
                sum = 0.0;
                for (VectorEntry ve : row) {
                    sum += ve.get() * weightM.get(j, ve.index());
                }
                cost.set(i, j, sum);
                this.setProgress((int)Math.floor(prevProgress += perIter));
                if (this.isCancelled()) {
                    return;
                }
                ++j;
            }
            ++i;
        }
        long after = System.currentTimeMillis();
        LAPSwingWorker.print("   Matrix mult: " + (after - before) + "ms");
    }

    private FlexCompRowMatrix getSparseMatrix(Matrix m) {
        int size = m.getRowCount();
        FlexCompRowMatrix M = new FlexCompRowMatrix(size, size);
        int i = 0;
        while (i < size) {
            M.setRow(i, new SparseVector((Vector)new DenseVector(m.getRow(i))));
            ++i;
        }
        M.compact();
        return M;
    }

    private String[] translate(int[] newIntRowOrder, String[] strings) {
        int N = strings.length;
        String[] newRowOrder = new String[N];
        int i = 0;
        while (i < N) {
            newRowOrder[i] = strings[newIntRowOrder[i]];
            ++i;
        }
        return newRowOrder;
    }

    private boolean different(String[] newRowOrder, ArrayList<String[]> prevOrders) {
        int N = newRowOrder.length;
        int K = prevOrders.size();
        int diff = 0;
        int i = 0;
        while (i < K) {
            int j = 0;
            while (j < N) {
                if (!newRowOrder[j].equals(prevOrders.get(i)[j])) {
                    ++diff;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return diff == K;
    }

    private FlexCompRowMatrix robSwap(FlexCompRowMatrix m, int[] ranks) {
        int size = ranks.length;
        FlexCompRowMatrix temp = new FlexCompRowMatrix(size, size);
        int i = 0;
        while (i < size) {
            int oldRowIndex = ranks[i];
            DenseVector dense = new DenseVector(size);
            int j = 0;
            while (j < size) {
                int oldColumnIndex = ranks[j];
                dense.set(j, m.get(oldRowIndex, oldColumnIndex));
                ++j;
            }
            temp.setRow(i, new SparseVector((Vector)dense));
            ++i;
        }
        return temp;
    }

    private DenseMatrix createWeightMatrix(int N) {
        System.out.println("   create weight matrix");
        long begin = System.currentTimeMillis();
        double[][] W = new double[N][N];
        int i = 0;
        while (i < N) {
            int j = i;
            while (j < N) {
                double d = Math.abs(i - j);
                W[j][i] = d;
                W[i][j] = d;
                ++j;
            }
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println("   Time to create matrix: " + (end - begin));
        return new DenseMatrix(W);
    }

    private static void print(String s) {
        System.out.println(s);
    }

    public void setIterations(int greedy, int opt) {
        this.greedyIterCount = greedy;
        this.totalIterCount = greedy + opt;
    }
}

