/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.clustering;

import edu.umd.coral.clustering.GreedyLAP;
import edu.umd.coral.clustering.MatrixReordering;
import edu.umd.coral.model.data.Matrix;
import java.util.ArrayList;
import javaasp.LinearAssignmentSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LAPAwesomeReordering
implements MatrixReordering {
    private final String INDENT = "   ";
    private int greedyIterCount = 1;
    private int totalIterCount = 1;

    public LAPAwesomeReordering(int greedyIter, int optIter) {
        this.greedyIterCount = greedyIter;
        this.totalIterCount = greedyIter + optIter;
    }

    @Override
    public Matrix reorder(Matrix originalMatrix) {
        System.out.println("reordering a matrix");
        long startMillis = System.currentTimeMillis();
        System.out.println("current time: " + (System.currentTimeMillis() - startMillis));
        Matrix[] components = Matrix.getConnectedComponents2(originalMatrix);
        System.out.println("found connected components " + components.length);
        System.out.println("current time: " + (System.currentTimeMillis() - startMillis));
        int size = components.length;
        Matrix[] reorderedComponents = new Matrix[size];
        int i = 0;
        Matrix[] matrixArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Matrix m = matrixArray[n2];
            reorderedComponents[i] = this.reorderConnectedMatrix(m);
            ++i;
            ++n2;
        }
        System.out.println("reordered connected components ");
        System.out.println("current time: " + (System.currentTimeMillis() - startMillis));
        Matrix matrix = Matrix.mergeComponents(reorderedComponents, originalMatrix.getMax());
        System.out.println("merged components ");
        System.out.println("current time: " + (System.currentTimeMillis() - startMillis));
        long endMillies = System.currentTimeMillis();
        System.out.println("total time to reorder: " + (endMillies - startMillis));
        return matrix;
    }

    private Matrix reorderConnectedMatrix(Matrix m) {
        System.out.println("   Reordering component of size " + m.getColumnCount());
        int size = m.getColumnCount();
        double[][] weightM = this.createWeightMatrix(size);
        boolean has_improvements = true;
        ArrayList<String[]> prevOrders = new ArrayList<String[]>();
        prevOrders.add(new String[size]);
        int i = 0;
        while (i < size) {
            ((String[])prevOrders.get((int)0))[i] = String.valueOf(i);
            ++i;
        }
        String[] newRowOrder = new String[size];
        int[] newIntRowOrder = new int[size];
        int[] newIntColOrder = new int[size];
        int iter = 0;
        double[][] M = (double[][])m.getData().clone();
        LinearAssignmentSolver las = new LinearAssignmentSolver();
        GreedyLAP greedy = new GreedyLAP();
        System.out.println("Starting reordering");
        while (iter < this.totalIterCount && has_improvements) {
            has_improvements = false;
            long b4 = System.currentTimeMillis();
            double[][] MT = (double[][])M.clone();
            long after = System.currentTimeMillis();
            LAPAwesomeReordering.print("Cloned: " + (after - b4));
            long before = System.currentTimeMillis();
            double[][] cost = this.dot(MT, weightM);
            if (iter < this.greedyIterCount) {
                LAPAwesomeReordering.print("   Doing stuff at " + iter + " iteration (greedy)");
                greedy.solve(size, cost, newIntColOrder, newIntRowOrder);
            } else {
                LAPAwesomeReordering.print("   Doing stuff at " + iter + " iteration (opt)");
                las.solve(size, cost, newIntColOrder, newIntRowOrder);
            }
            newRowOrder = this.translate(newIntRowOrder, (String[])prevOrders.get(prevOrders.size() - 1));
            if (this.different(newRowOrder, prevOrders)) {
                prevOrders.add(newRowOrder);
                has_improvements = true;
                M = this.robSwap(M, newIntRowOrder);
            }
            after = System.currentTimeMillis();
            LAPAwesomeReordering.print("   Iteration took " + (after - before));
            ++iter;
        }
        String[] col_names = new String[size];
        String[] lastOrder = (String[])prevOrders.get(prevOrders.size() - 1);
        int i2 = 0;
        while (i2 < size) {
            col_names[i2] = m.getColumnName(Integer.parseInt(lastOrder[i2]));
            ++i2;
        }
        Matrix reordered = new Matrix(M, col_names, (String[])col_names.clone());
        return reordered;
    }

    private String[] translate(int[] newIntRowOrder, String[] strings) {
        int N = strings.length;
        String[] newRowOrder = new String[N];
        int i = 0;
        while (i < N) {
            newRowOrder[i] = strings[newIntRowOrder[i]];
            ++i;
        }
        return newRowOrder;
    }

    private boolean different(String[] newRowOrder, ArrayList<String[]> prevOrders) {
        int N = newRowOrder.length;
        int K = prevOrders.size();
        int diff = 0;
        int i = 0;
        while (i < K) {
            int j = 0;
            while (j < N) {
                if (!newRowOrder[j].equals(prevOrders.get(i)[j])) {
                    ++diff;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return diff == K;
    }

    private double[][] robSwap(double[][] m, int[] ranks) {
        long b4 = System.currentTimeMillis();
        int size = ranks.length;
        double[][] data = new double[size][size];
        int i = 0;
        while (i < size) {
            int oldRowIndex = ranks[i];
            int j = 0;
            while (j < size) {
                int oldColumnIndex = ranks[j];
                data[i][j] = m[oldRowIndex][oldColumnIndex];
                ++j;
            }
            ++i;
        }
        long after = System.currentTimeMillis();
        System.out.println("Rob swap:" + (after - b4));
        return data;
    }

    private double[][] dot(double[][] A, double[][] B) {
        long b4 = System.currentTimeMillis();
        int N = A.length;
        double[][] result = new double[N][N];
        int i = 0;
        while (i < N) {
            int j = 0;
            while (j < N) {
                double sum = 0.0;
                int k = 0;
                while (k < N) {
                    sum += A[i][k] * B[k][j];
                    ++k;
                }
                result[i][j] = sum;
                ++j;
            }
            ++i;
        }
        long after = System.currentTimeMillis();
        System.out.println("Dot product: " + (after - b4));
        return result;
    }

    private double[][] createWeightMatrix(int N) {
        System.out.println("   create weight matrix");
        long begin = System.currentTimeMillis();
        double[][] W = new double[N][N];
        int i = 0;
        while (i < N) {
            int j = i;
            while (j < N) {
                double d = Math.abs(i - j);
                W[j][i] = d;
                W[i][j] = d;
                ++j;
            }
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println("Time to create matrix: " + (end - begin));
        return W;
    }

    private static void print(String s) {
        System.out.println(s);
    }
}

