/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.clustering;

import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import javaasp.LinearAssignmentSolver;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;

public class GreedyLAP
extends LinearAssignmentSolver {
    Set<Integer> paired_columns;
    Set<Integer> paired_rows;

    public void solve(int N, FlexCompRowMatrix cost, int[] newIntColOrder, int[] newIntRowOrder) {
        this.paired_columns = new HashSet<Integer>();
        this.paired_rows = new HashSet<Integer>();
        long before = System.currentTimeMillis();
        cost.compact();
        PriorityQueue<Triplet> q = new PriorityQueue<Triplet>();
        for (MatrixEntry me : cost) {
            if (me.get() == 0.0) continue;
            q.add(new Triplet(me.row(), me.column(), me.get()));
        }
        while (!q.isEmpty() && this.paired_rows.size() < N) {
            Triplet t = (Triplet)q.poll();
            if (this.paired_rows.contains(t.row) || this.paired_columns.contains(t.column)) continue;
            this.paired_rows.add(t.row);
            this.paired_columns.add(t.column);
            newIntRowOrder[t.row] = t.column;
        }
        long after = System.currentTimeMillis();
        System.out.println("        Greedy interation: " + (after - before));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Triplet
    implements Comparable<Triplet> {
        public int row;
        public int column;
        public double cost;

        public Triplet(int r, int c, double cost) {
            this.row = r;
            this.column = c;
            this.cost = cost;
        }

        @Override
        public int compareTo(Triplet t) {
            if (this.cost < t.cost) {
                return -1;
            }
            if (t.cost == this.cost) {
                return 0;
            }
            return 1;
        }
    }
}

