/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.coral.clustering;

import edu.umd.coral.clustering.MatrixReordering;
import edu.umd.coral.model.data.Matrix;
import edu.umd.coral.model.data.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CuthillMcKeeReordering
implements MatrixReordering {
    @Override
    public Matrix reorder(Matrix matrix) {
        if (matrix == null) {
            return null;
        }
        PriorityQueue<Vertex> graph = this.buildCooccurrenceGraph(matrix);
        PriorityQueue<Vertex> frontier = new PriorityQueue<Vertex>(10, new DegreeComparator());
        HashSet<Vertex> expandedVertices = new HashSet<Vertex>();
        ArrayList<Integer> oldToNewIndex = new ArrayList<Integer>();
        int rowCount = matrix.getRowCount();
        while (!graph.isEmpty()) {
            Vertex v = graph.poll();
            oldToNewIndex.add(v.getIndex());
            frontier.add(v);
            this.traverseComponent(frontier, expandedVertices, oldToNewIndex, graph);
        }
        frontier.clear();
        frontier = null;
        graph = null;
        expandedVertices.clear();
        expandedVertices = null;
        String[] names = new String[rowCount];
        double[][] data = new double[rowCount][rowCount];
        int i = 0;
        while (i < rowCount) {
            int oldRowIndex = oldToNewIndex.get(i);
            names[i] = matrix.getRowName(oldRowIndex);
            int j = 0;
            while (j < rowCount) {
                int oldColumnIndex = oldToNewIndex.get(j);
                data[i][j] = matrix.getElement(oldRowIndex, oldColumnIndex);
                ++j;
            }
            ++i;
        }
        Matrix m = new Matrix(data, names, names, matrix.getMax());
        return m;
    }

    private PriorityQueue<Vertex> buildCooccurrenceGraph(Matrix matrix) {
        Vertex v;
        PriorityQueue<Vertex> graph = new PriorityQueue<Vertex>(10, new DegreeComparator());
        HashMap<String, Vertex> vertices = new HashMap<String, Vertex>();
        int rowCount = matrix.getRowCount();
        int row = 0;
        while (row < rowCount) {
            v = new Vertex(matrix.getRowName(row), row);
            vertices.put(matrix.getRowName(row), v);
            ++row;
        }
        row = 0;
        while (row < rowCount) {
            v = (Vertex)vertices.get(matrix.getRowName(row));
            int column = 0;
            while (column < rowCount) {
                double value = matrix.getElement(row, column);
                if (value != 0.0 && row != column) {
                    v.addNeighbor((Vertex)vertices.get(matrix.getRowName(column)), value);
                }
                ++column;
            }
            graph.add(v);
            ++row;
        }
        return graph;
    }

    private void traverseComponent(PriorityQueue<Vertex> frontier, Set<Vertex> expandedVertices, ArrayList<Integer> indices, PriorityQueue<Vertex> graph) {
        PriorityQueue<Vertex> q = new PriorityQueue<Vertex>(10, new DegreeComparator());
        while (!frontier.isEmpty()) {
            Vertex v = frontier.poll();
            graph.remove(v);
            if (!expandedVertices.contains(v)) {
                Collection<Vertex> neighbors = v.getNeighbors();
                q.addAll(neighbors);
                while (!q.isEmpty()) {
                    Vertex u = q.poll();
                    if (expandedVertices.contains(u) || frontier.contains(u)) continue;
                    frontier.add(u);
                    indices.add(u.getIndex());
                }
            }
            expandedVertices.add(v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DegreeComparator
    implements Comparator<Vertex> {
        @Override
        public int compare(Vertex v1, Vertex v2) {
            if (v1.getDegree() == v2.getDegree()) {
                return 0;
            }
            if (v1.getDegree() < v2.getDegree()) {
                return -1;
            }
            return 1;
        }
    }
}

