/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.expression;

import prefuse.Visualization;
import prefuse.data.Tuple;
import prefuse.data.expression.BooleanLiteral;
import prefuse.data.expression.Expression;
import prefuse.data.search.SearchTupleSet;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;

public class SearchPredicate
extends InGroupPredicate {
    private Expression m_incEmpty;
    private int paramCount = 0;

    public SearchPredicate() {
        this(Visualization.SEARCH_ITEMS, true);
        this.paramCount = 0;
    }

    public SearchPredicate(boolean includeAllByDefault) {
        this(Visualization.SEARCH_ITEMS, includeAllByDefault);
    }

    public SearchPredicate(String group, boolean includeAllByDefault) {
        super(group);
        this.m_incEmpty = new BooleanLiteral(includeAllByDefault);
        this.paramCount = 2;
    }

    @Override
    public boolean getBoolean(Tuple t) {
        String group = this.getGroup(t);
        if (group == null) {
            return false;
        }
        boolean incEmpty = this.m_incEmpty.getBoolean(t);
        VisualItem item = (VisualItem)t;
        Visualization vis = item.getVisualization();
        SearchTupleSet search = (SearchTupleSet)vis.getGroup(group);
        if (search == null && incEmpty) {
            return true;
        }
        String query = search.getQuery();
        return incEmpty && (query == null || query.length() == 0) || vis.isInGroup(item, group);
    }

    @Override
    public void addParameter(Expression e) {
        if (this.paramCount == 0) {
            super.addParameter(e);
        } else if (this.paramCount == 1) {
            this.m_incEmpty = e;
        } else {
            throw new IllegalStateException("This function takes only 2 parameters.");
        }
    }

    @Override
    public String getName() {
        return "MATCH";
    }

    @Override
    public int getParameterCount() {
        return 2;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + "(" + this.m_group + ", " + this.m_incEmpty + ")";
    }
}

