/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.display;

import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import prefuse.Display;
import prefuse.util.display.ScaleSelector;
import prefuse.util.io.IOLib;
import prefuse.util.io.SimpleFileFilter;

public class ExportDisplayAction
extends AbstractAction {
    private Display display;
    private JFileChooser chooser;
    private ScaleSelector scaler;

    public ExportDisplayAction(Display display) {
        this.display = display;
    }

    private void init() {
        this.scaler = new ScaleSelector();
        this.chooser = new JFileChooser();
        this.chooser.setDialogType(1);
        this.chooser.setDialogTitle("Export Prefuse Display...");
        this.chooser.setAcceptAllFileFilterUsed(false);
        HashSet<String> seen = new HashSet<String>();
        String[] fmts = ImageIO.getWriterFormatNames();
        int i = 0;
        while (i < fmts.length) {
            String s = fmts[i].toLowerCase();
            if (s.length() == 3 && !seen.contains(s)) {
                seen.add(s);
                this.chooser.setFileFilter(new SimpleFileFilter(s, String.valueOf(s.toUpperCase()) + " Image (*." + s + ")"));
            }
            ++i;
        }
        seen.clear();
        seen = null;
        this.chooser.setAccessory(this.scaler);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.chooser == null) {
            this.init();
        }
        File f = null;
        this.scaler.setImage(this.display.getOffscreenBuffer());
        int returnVal = this.chooser.showSaveDialog(this.display);
        if (returnVal != 0) {
            return;
        }
        f = this.chooser.getSelectedFile();
        String format = ((SimpleFileFilter)this.chooser.getFileFilter()).getExtension();
        String ext = IOLib.getExtension(f);
        if (!format.equals(ext)) {
            f = new File(String.valueOf(f.toString()) + "." + format);
        }
        double scale = this.scaler.getScale();
        boolean success = false;
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            System.out.print("Saving image " + f.getName() + ", " + format + " format...");
            success = this.display.saveImage(out, format, scale);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            System.out.println("\tDONE");
        }
        catch (Exception e) {
            success = false;
        }
        if (!success) {
            JOptionPane.showMessageDialog(this.display, "Error Saving Image!", "Image Save Error", 0);
        }
    }
}

