/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.render.EdgeRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.render.ShapeRenderer;
import prefuse.util.PredicateChain;
import prefuse.visual.EdgeItem;
import prefuse.visual.VisualItem;

public class DefaultRendererFactory
implements RendererFactory {
    private PredicateChain m_chain = new PredicateChain();
    private Renderer m_itemRenderer;
    private Renderer m_edgeRenderer;

    public DefaultRendererFactory() {
        this(new ShapeRenderer());
    }

    public DefaultRendererFactory(Renderer itemRenderer) {
        this(itemRenderer, new EdgeRenderer());
    }

    public DefaultRendererFactory(Renderer itemRenderer, Renderer edgeRenderer) {
        this.m_itemRenderer = itemRenderer;
        this.m_edgeRenderer = edgeRenderer;
    }

    public void setDefaultRenderer(Renderer r) {
        this.m_itemRenderer = r;
    }

    public Renderer getDefaultRenderer() {
        return this.m_itemRenderer;
    }

    public void setDefaultEdgeRenderer(Renderer r) {
        this.m_edgeRenderer = r;
    }

    public Renderer getDefaultEdgeRenderer() {
        return this.m_edgeRenderer;
    }

    public void add(Predicate p, Renderer r) {
        this.m_chain.add(p, r);
    }

    public void add(String predicate, Renderer r) {
        Predicate p = (Predicate)ExpressionParser.parse(predicate);
        this.add(p, r);
    }

    @Override
    public Renderer getRenderer(VisualItem item) {
        Renderer r = (Renderer)this.m_chain.get(item);
        if (r != null) {
            return r;
        }
        if (item instanceof EdgeItem) {
            return this.m_edgeRenderer;
        }
        return this.m_itemRenderer;
    }
}

