/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.util;

import prefuse.data.CascadedTable;
import prefuse.data.Table;
import prefuse.data.column.IntColumn;
import prefuse.data.util.RowManager;
import prefuse.util.collections.IntIntSortedMap;
import prefuse.util.collections.IntIntTreeMap;

public class FilteredRowManager
extends RowManager {
    protected IntColumn m_childToParent;
    protected IntIntSortedMap m_parentToChild;

    public FilteredRowManager(Table table) {
        super(table);
        this.m_childToParent = new IntColumn(table.getRowCount());
        this.m_parentToChild = new IntIntTreeMap(false);
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        this.m_parentToChild.clear();
        int i = 0;
        while (i < this.m_childToParent.getRowCount()) {
            this.m_childToParent.setInt(-1, i);
            ++i;
        }
    }

    public int addRow(int parentRow) {
        int r = super.addRow();
        this.put(r, parentRow);
        return r;
    }

    @Override
    public boolean releaseRow(int row) {
        if (super.releaseRow(row)) {
            this.remove(row);
            return true;
        }
        return false;
    }

    @Override
    public int getColumnRow(int row, int col) {
        return ((CascadedTable)this.m_table).getParentTable().getColumnRow(this.getParentRow(row), col);
    }

    @Override
    public int getTableRow(int columnRow, int col) {
        return this.getChildRow(columnRow);
    }

    public int getParentRow(int childRow) {
        if (childRow >= this.m_childToParent.getRowCount()) {
            return -1;
        }
        return this.m_childToParent.getInt(childRow);
    }

    public int getChildRow(int parentRow) {
        int val = this.m_parentToChild.get(parentRow);
        return val == Integer.MIN_VALUE ? -1 : val;
    }

    public void put(int childRow, int parentRow) {
        if (childRow >= this.m_childToParent.getRowCount()) {
            this.m_childToParent.setMaximumRow(childRow + 1);
        }
        this.m_childToParent.setInt(parentRow, childRow);
        this.m_parentToChild.put(parentRow, childRow);
    }

    public void remove(int childRow) {
        int parentRow = this.m_childToParent.getInt(childRow);
        this.m_childToParent.setInt(-1, childRow);
        this.m_parentToChild.remove(parentRow);
    }
}

