/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.expression;

import prefuse.data.Schema;
import prefuse.data.Tuple;
import prefuse.data.expression.Literal;
import prefuse.data.expression.Predicate;

public class BooleanLiteral
extends Literal
implements Predicate {
    public static final BooleanLiteral TRUE = new BooleanLiteral(true);
    public static final BooleanLiteral FALSE = new BooleanLiteral(false);
    private final boolean m_value;

    public BooleanLiteral(boolean b) {
        this.m_value = b;
    }

    @Override
    public boolean getBoolean(Tuple tuple) {
        return this.m_value;
    }

    @Override
    public Class getType(Schema s) {
        return Boolean.TYPE;
    }

    @Override
    public Object get(Tuple t) {
        return this.getBoolean(t) ? Boolean.TRUE : Boolean.FALSE;
    }

    public String toString() {
        return String.valueOf(this.m_value).toUpperCase();
    }
}

