/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.column;

import prefuse.data.DataTypeException;
import prefuse.data.column.AbstractColumn;
import prefuse.data.event.ColumnListener;

public class ConstantColumn
extends AbstractColumn {
    private int m_size;

    public ConstantColumn(Class type, Object defaultValue) {
        super(type, defaultValue);
    }

    @Override
    public int getRowCount() {
        return this.m_size + 1;
    }

    @Override
    public void setMaximumRow(int nrows) {
        this.m_size = nrows;
    }

    @Override
    public Object get(int row) {
        if (row < 0 || row > this.m_size) {
            throw new IllegalArgumentException("Row index out of bounds: " + row);
        }
        return this.m_defaultValue;
    }

    @Override
    public void set(Object val, int row) throws DataTypeException {
        throw new UnsupportedOperationException("Can't set values on a ConstantColumn");
    }

    @Override
    public boolean canSet(Class type) {
        return false;
    }

    @Override
    public void addColumnListener(ColumnListener listener) {
    }

    @Override
    public void removeColumnListener(ColumnListener listener) {
    }
}

