/*
 * Decompiled with CFR 0.152.
 */
package prefuse.activity;

import prefuse.activity.ActivityListener;
import prefuse.activity.ActivityManager;
import prefuse.activity.Pacer;
import prefuse.util.collections.CopyOnWriteArrayList;

public abstract class Activity {
    public static final long INFINITY = -1L;
    public static final long DEFAULT_STEP_TIME = 15L;
    private boolean m_enabled = true;
    private Pacer m_pacer;
    private long m_startTime = -1L;
    private long m_duration = -1L;
    private long m_stepTime = -1L;
    private long m_nextTime = -1L;
    private boolean m_isRunning = false;
    private boolean m_isScheduled = false;
    private CopyOnWriteArrayList m_listeners;

    public Activity(long duration) {
        this(duration, 15L);
    }

    public Activity(long duration, long stepTime) {
        this(duration, stepTime, System.currentTimeMillis());
    }

    public Activity(long duration, long stepTime, long startTime) {
        this.m_startTime = startTime;
        this.m_nextTime = startTime;
        this.m_duration = duration;
        this.m_stepTime = stepTime;
    }

    public void run() {
        ActivityManager.scheduleNow(this);
    }

    public void runAt(long startTime) {
        ActivityManager.scheduleAt(this, startTime);
    }

    public void runAfter(Activity before) {
        ActivityManager.scheduleAfter(before, this);
    }

    public void alwaysRunAfter(Activity before) {
        ActivityManager.alwaysScheduleAfter(before, this);
    }

    protected abstract void run(long var1);

    long runActivity(long currentTime) {
        if (currentTime < this.m_startTime) {
            return this.m_startTime - currentTime;
        }
        long elapsedTime = currentTime - this.m_startTime;
        if (this.m_duration == 0L || currentTime >= this.getStopTime()) {
            if (!this.setRunning(true)) {
                this.fireActivityStarted();
            }
            if (this.m_enabled) {
                this.run(elapsedTime);
                this.fireActivityStepped();
            }
            this.setRunning(false);
            this.fireActivityFinished();
            return -1L;
        }
        if (currentTime >= this.m_nextTime) {
            if (!this.setRunning(true)) {
                this.fireActivityStarted();
            }
            if (this.m_enabled) {
                this.run(elapsedTime);
                this.fireActivityStepped();
            }
            this.m_nextTime = currentTime + this.m_stepTime;
        }
        return this.m_nextTime - currentTime;
    }

    public void cancel() {
        ActivityManager.cancelActivity(this);
    }

    public synchronized boolean isScheduled() {
        return this.m_isScheduled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setScheduled(boolean s) {
        boolean fire;
        Activity activity = this;
        synchronized (activity) {
            fire = s && !this.m_isScheduled;
            this.m_isScheduled = s;
        }
        if (fire) {
            this.fireActivityScheduled();
        }
    }

    synchronized boolean setRunning(boolean s) {
        boolean b = this.m_isRunning;
        this.m_isRunning = s;
        return b;
    }

    public synchronized boolean isRunning() {
        return this.m_isRunning;
    }

    public void addActivityListener(ActivityListener l) {
        if (this.m_listeners == null) {
            this.m_listeners = new CopyOnWriteArrayList();
        }
        if (!this.m_listeners.contains(l)) {
            this.m_listeners.add(l);
        }
    }

    public void removeActivityListener(ActivityListener l) {
        if (this.m_listeners == null) {
            return;
        }
        this.m_listeners.remove(l);
        if (this.m_listeners.size() == 0) {
            this.m_listeners = null;
        }
    }

    protected void fireActivityScheduled() {
        if (this.m_listeners == null) {
            return;
        }
        Object[] a = this.m_listeners.getArray();
        int i = 0;
        while (i < a.length) {
            ((ActivityListener)a[i]).activityScheduled(this);
            ++i;
        }
    }

    protected void fireActivityStarted() {
        if (this.m_listeners == null) {
            return;
        }
        Object[] a = this.m_listeners.getArray();
        int i = 0;
        while (i < a.length) {
            ((ActivityListener)a[i]).activityStarted(this);
            ++i;
        }
    }

    protected void fireActivityStepped() {
        if (this.m_listeners == null) {
            return;
        }
        Object[] a = this.m_listeners.getArray();
        int i = 0;
        while (i < a.length) {
            ((ActivityListener)a[i]).activityStepped(this);
            ++i;
        }
    }

    protected void fireActivityFinished() {
        if (this.m_listeners == null) {
            return;
        }
        Object[] a = this.m_listeners.getArray();
        int i = 0;
        while (i < a.length) {
            ((ActivityListener)a[i]).activityFinished(this);
            ++i;
        }
    }

    protected void fireActivityCancelled() {
        if (this.m_listeners == null) {
            return;
        }
        Object[] a = this.m_listeners.getArray();
        int i = 0;
        while (i < a.length) {
            ((ActivityListener)a[i]).activityCancelled(this);
            ++i;
        }
    }

    public double getPace(long elapsedTime) {
        long duration = this.getDuration();
        double frac = duration == 0L ? 0.0 : (double)elapsedTime / (double)duration;
        frac = Math.min(1.0, Math.max(0.0, frac));
        return this.m_pacer != null ? this.m_pacer.pace(frac) : frac;
    }

    public synchronized Pacer getPacingFunction() {
        return this.m_pacer;
    }

    public synchronized void setPacingFunction(Pacer pfunc) {
        this.m_pacer = pfunc;
    }

    public long getStopTime() {
        if (this.m_duration == -1L) {
            return Long.MAX_VALUE;
        }
        return this.m_startTime + this.m_duration;
    }

    public long getNextTime() {
        return this.m_nextTime;
    }

    public long getDuration() {
        return this.m_duration;
    }

    public void setDuration(long duration) {
        this.m_duration = duration;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public void setStartTime(long time) {
        this.m_startTime = time;
    }

    public long getStepTime() {
        return this.m_stepTime;
    }

    public void setStepTime(long time) {
        this.m_stepTime = time;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean s) {
        this.m_enabled = s;
    }
}

