/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.distortion;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.action.layout.Layout;
import prefuse.visual.VisualItem;

public abstract class Distortion
extends Layout {
    private Point2D m_tmp = new Point2D.Double();
    protected boolean m_distortSize = true;
    protected boolean m_distortX = true;
    protected boolean m_distortY = true;

    public Distortion() {
    }

    public Distortion(String group) {
        super(group);
    }

    public void setSizeDistorted(boolean s) {
        this.m_distortSize = s;
    }

    public boolean isSizeDistorted() {
        return this.m_distortSize;
    }

    @Override
    public void run(double frac) {
        Rectangle2D bounds = this.getLayoutBounds();
        Point2D anchor = this.correct(this.m_anchor, bounds);
        Iterator iter = this.getVisualization().visibleItems(this.m_group);
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            if (item.isFixed()) continue;
            item.setX(item.getEndX());
            item.setY(item.getEndY());
            item.setSize(item.getEndSize());
            if (anchor == null) continue;
            Rectangle2D bbox = item.getBounds();
            double x = item.getX();
            double y = item.getY();
            if (this.m_distortX) {
                x = this.distortX(x, anchor, bounds);
                item.setX(x);
            }
            if (this.m_distortY) {
                y = this.distortY(y, anchor, bounds);
                item.setY(y);
            }
            if (!this.m_distortSize) continue;
            double sz = this.distortSize(bbox, x, y, anchor, bounds);
            item.setSize(sz * item.getSize());
        }
    }

    protected Point2D correct(Point2D anchor, Rectangle2D bounds) {
        if (anchor == null) {
            return anchor;
        }
        double x = anchor.getX();
        double y = anchor.getY();
        double x1 = bounds.getMinX();
        double y1 = bounds.getMinY();
        double x2 = bounds.getMaxX();
        double y2 = bounds.getMaxY();
        double d = x < x1 ? x1 : (x = x > x2 ? x2 : x);
        y = y < y1 ? y1 : (y > y2 ? y2 : y);
        this.m_tmp.setLocation(x, y);
        return this.m_tmp;
    }

    protected abstract double distortX(double var1, Point2D var3, Rectangle2D var4);

    protected abstract double distortY(double var1, Point2D var3, Rectangle2D var4);

    protected abstract double distortSize(Rectangle2D var1, double var2, double var4, Point2D var6, Rectangle2D var7);
}

