/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.util.logging.Logger;
import prefuse.action.EncoderAction;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.visual.VisualItem;

public class SizeAction
extends EncoderAction {
    protected double m_defaultSize = 1.0;

    public SizeAction() {
    }

    public SizeAction(String group) {
        super(group);
    }

    public SizeAction(String group, double size) {
        super(group);
        this.m_defaultSize = size;
    }

    public double getDefaultSize() {
        return this.m_defaultSize;
    }

    public void setDefaultSize(double defaultSize) {
        this.m_defaultSize = defaultSize;
    }

    public void add(Predicate p, double size) {
        super.add(p, new Double(size));
    }

    public void add(String expr, double size) {
        Predicate p = (Predicate)ExpressionParser.parse(expr);
        this.add(p, size);
    }

    public void add(Predicate p, SizeAction f) {
        super.add(p, f);
    }

    public void add(String expr, SizeAction f) {
        Predicate p = (Predicate)ExpressionParser.parse(expr);
        super.add(p, f);
    }

    @Override
    public void process(VisualItem item, double frac) {
        double size = this.getSize(item);
        double old = item.getSize();
        item.setStartSize(old);
        item.setEndSize(size);
        item.setSize(size);
    }

    public double getSize(VisualItem item) {
        Object o = this.lookup(item);
        if (o != null) {
            if (o instanceof SizeAction) {
                return ((SizeAction)o).getSize(item);
            }
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            Logger.getLogger(this.getClass().getName()).warning("Unrecognized Object from predicate chain.");
        }
        return this.m_defaultSize;
    }
}

