/*
 * Decompiled with CFR 0.152.
 */
package test;

import edu.umd.coral.clustering.LAPAwesomeReordering;
import edu.umd.coral.clustering.SpectralReordering;
import edu.umd.coral.model.data.Matrix;
import junit.framework.TestCase;

public class TestReordering
extends TestCase {
    public void testSpectralPreserveValues() {
        double[][] data = new double[][]{{0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 0.0}, {1.0, 1.0, 0.0, 0.0}};
        String[] names = new String[]{"a", "b", "c", "d"};
        Matrix matrix = new Matrix(data, names, names);
        SpectralReordering so = new SpectralReordering();
        Matrix rMatrix = so.reorder(matrix);
        String[] rowNames = rMatrix.rowNames;
        int index1 = -1;
        int index2 = -1;
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                int k = 0;
                while (k < 4) {
                    if (names[k].equals(rowNames[i])) {
                        index1 = k;
                    }
                    if (names[k].equals(rowNames[j])) {
                        index2 = k;
                    }
                    ++k;
                }
                TestReordering.assertTrue((rMatrix.getElement(i, j) == matrix.getElement(index1, index2) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
    }

    public void testSpectralTen() {
        double[][] data = new double[][]{{0.0, 0.0, 1.0, 1.0}, {0.0, 0.0, 1.0, 1.0}, {1.0, 1.0, 1.0, 0.0}, {1.0, 1.0, 0.0, 0.0}};
        String[] names = new String[]{"a", "b", "c", "d"};
        Matrix matrix = new Matrix(data, names, names);
        SpectralReordering so = new SpectralReordering();
        Matrix rMatrix = so.reorder(matrix);
        String[] rowNames = rMatrix.rowNames;
        int index1 = -1;
        int index2 = -1;
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                int k = 0;
                while (k < 4) {
                    if (names[k].equals(rowNames[i])) {
                        index1 = k;
                    }
                    if (names[k].equals(rowNames[j])) {
                        index2 = k;
                    }
                    ++k;
                }
                TestReordering.assertTrue((rMatrix.getElement(i, j) == matrix.getElement(index1, index2) ? 1 : 0) != 0);
                ++j;
            }
            ++i;
        }
    }

    public void testLAP() {
        double[][] data = new double[][]{{0.0, 0.0, 1.0, 2.0}, {0.0, 0.0, 3.0, 4.0}, {1.0, 3.0, 0.0, 0.0}, {2.0, 4.0, 0.0, 0.0}};
        String[] names = new String[]{"a", "b", "c", "d"};
        Matrix matrix = new Matrix(data, names, names);
        LAPAwesomeReordering so = new LAPAwesomeReordering(11, 0);
        Matrix rMatrix = so.reorder(matrix);
        int i = 0;
        while (i < 4) {
            int r = rMatrix.getRowIndex(matrix.getRowName(i));
            int j = 0;
            while (j < 4) {
                int c = rMatrix.getColumnIndex(matrix.getColumnName(j));
                TestReordering.assertEquals((Object)matrix.getElement(i, j), (Object)rMatrix.getElement(r, c));
                ++j;
            }
            ++i;
        }
    }

    public void testRowColumnSums() {
    }
}

