/*
 * Decompiled with CFR 0.152.
 */
package test;

import edu.umd.coral.managers.DenseSubgraphFinder;
import edu.umd.coral.managers.FastDenseSubgraphFinder;
import edu.umd.coral.model.data.Clique;
import edu.umd.coral.model.data.Matrix;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import junit.framework.TestCase;

public class TestDenseSubgraphs
extends TestCase {
    public void testCalculateDensity() {
        DenseSubgraphFinder dsf = new DenseSubgraphFinder();
        double[][] data = new double[][]{{6.0, 5.0, 4.0, 2.0, 0.0, 0.0}, {5.0, 6.0, 5.0, 3.0, 0.0, 0.0}, {4.0, 5.0, 6.0, 4.0, 0.0, 0.0}, {2.0, 3.0, 4.0, 6.0, 2.0, 2.0}, {0.0, 0.0, 0.0, 2.0, 6.0, 6.0}, {0.0, 0.0, 0.0, 2.0, 6.0, 6.0}};
        double[][] density = dsf.getDensityMatrix(data);
        TestDenseSubgraphs.assertTrue((density[0][1] == 2.5 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[0][2] == 4.666666507720947 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[0][3] == 5.75 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[0][4] == 5.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[0][5] == 5.5 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[1][2] == 2.5 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[1][3] == 4.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[1][4] == 3.5 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[1][5] == (double)4.4f ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[2][3] == 2.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[2][4] == 2.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[2][5] == 3.5 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[3][4] == 1.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[3][5] == 3.3333332538604736 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[4][5] == 3.0 ? 1 : 0) != 0);
    }

    public void testGetDenseSubgraphs() {
        double[][] data = new double[][]{{6.0, 5.0, 4.0, 2.0, 0.0, 0.0}, {5.0, 6.0, 5.0, 3.0, 0.0, 0.0}, {4.0, 5.0, 6.0, 4.0, 0.0, 0.0}, {2.0, 3.0, 4.0, 6.0, 2.0, 2.0}, {0.0, 0.0, 0.0, 2.0, 6.0, 6.0}, {0.0, 0.0, 0.0, 2.0, 6.0, 6.0}};
        DenseSubgraphFinder dsf = new DenseSubgraphFinder();
        double[][] density = dsf.getDensityMatrix(data);
        Set<Integer> set = dsf.findMaxDensity(density);
        ArrayList<Integer> list = new ArrayList<Integer>(set);
        Collections.sort(list);
        TestDenseSubgraphs.assertTrue((list.get(0) == 0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((list.get(1) == 4 ? 1 : 0) != 0);
    }

    public void testGetDenseSubgraphs2() {
        System.out.println("---------------------------");
        double[][] data = new double[][]{{0.0, 1.0, 1.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 5.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 2.0, 2.0, 6.0, 0.0, 6.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 6.0, 6.0, 0.0, 6.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
        String[] columnNames = new String[10];
        Matrix m = new Matrix(data, columnNames, columnNames, 6.0);
        DenseSubgraphFinder dsf = new DenseSubgraphFinder();
        ArrayList<Clique> slowCliques = dsf.getCliques(m, false);
        System.out.println(slowCliques);
        FastDenseSubgraphFinder fdsf = new FastDenseSubgraphFinder();
        ArrayList<Clique> fastCliques = fdsf.getCliques(m, false);
        System.out.println(fastCliques);
    }

    public void testGetFastDenseSubgraphs() {
        FastDenseSubgraphFinder dsf = new FastDenseSubgraphFinder();
        double[][] data = new double[][]{{6.0, 5.0, 4.0, 2.0, 0.0, 0.0}, {5.0, 6.0, 5.0, 3.0, 0.0, 0.0}, {4.0, 5.0, 6.0, 4.0, 0.0, 0.0}, {2.0, 3.0, 4.0, 6.0, 2.0, 2.0}, {0.0, 0.0, 0.0, 2.0, 6.0, 6.0}, {0.0, 0.0, 0.0, 2.0, 6.0, 6.0}};
        double[][] density = dsf.getSumsMatrix(data);
        TestDenseSubgraphs.assertTrue((density[0][1] == 5.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[0][2] == 14.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[0][3] == 23.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[0][4] == 25.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[0][5] == 33.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[1][2] == 5.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[1][3] == 12.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[1][4] == 14.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[1][5] == 22.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[2][3] == 4.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[2][4] == 6.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[2][5] == 14.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[3][4] == 2.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[3][5] == 10.0 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((density[4][5] == 6.0 ? 1 : 0) != 0);
        Set<Integer> set = dsf.findMaxDensity(density);
        ArrayList<Integer> list = new ArrayList<Integer>(set);
        Collections.sort(list);
        TestDenseSubgraphs.assertTrue((list.get(0) == 3 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((list.get(1) == 5 ? 1 : 0) != 0);
        HashMap<Integer, Integer> histogram = new HashMap<Integer, Integer>();
        double sum = 0.0;
        int n = data.length;
        int count = (n - 1) * (n - 1);
        int i = 0;
        while (i < n - 1) {
            int j = i + 1;
            while (j < n) {
                double value = data[i][j];
                if (value > 0.0) {
                    ++count;
                    sum += value;
                }
                if (histogram.containsKey((int)value)) {
                    int h = (Integer)histogram.get((int)value);
                    histogram.put((int)value, h + 1);
                } else {
                    histogram.put((int)value, 1);
                }
                ++j;
            }
            ++i;
        }
        double avg_edge_weight = sum / (double)count;
        ArrayList<Clique> cliques = dsf.constructCliques(set, density, avg_edge_weight, false, n);
        TestDenseSubgraphs.assertTrue((cliques.size() == 2 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((cliques.get(0).getIndices().size() == 4 ? 1 : 0) != 0);
        TestDenseSubgraphs.assertTrue((cliques.get(1).getIndices().size() == 2 ? 1 : 0) != 0);
    }

    public void testSlowFastResults() {
        DenseSubgraphFinder dsf = new DenseSubgraphFinder();
        FastDenseSubgraphFinder fdsf = new FastDenseSubgraphFinder();
        try {
            int j;
            FileInputStream fstream = new FileInputStream("/Users/lynxoid/Dropbox/coral/svn/coral_cluster/jSwingCoral/nearopt.txt");
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            int i = 0;
            String line = br.readLine();
            String[] parts = line.split(",");
            int n = parts.length;
            Matrix m = new Matrix(n, n);
            while ((line = br.readLine()) != null) {
                parts = line.split(",");
                TestDenseSubgraphs.assertTrue((n == parts.length ? 1 : 0) != 0);
                j = 0;
                while (j < n) {
                    int val = (int)Float.parseFloat(parts[j]);
                    m.setElement(i, j, val);
                    ++j;
                }
                ++i;
            }
            double[][] slowDensity = dsf.getDensityMatrix(m.getData());
            double[][] fastSums = fdsf.getSumsMatrix(m.getData());
            double[][] fastDensityMod = new double[n][n];
            i = 0;
            while (i < n) {
                j = i;
                while (j < n) {
                    int s = j - i + 1;
                    fastDensityMod[i][j] = fastSums[i][j] / (double)s;
                    double cfr_ignored_0 = slowDensity[i][j];
                    double cfr_ignored_1 = fastDensityMod[i][j];
                    ++j;
                }
                ++i;
            }
            ArrayList<Clique> slowCliques = dsf.getCliques(m, true);
            ArrayList<Clique> fastCliques = fdsf.getCliques(m, true);
            TestDenseSubgraphs.assertTrue((slowCliques.size() == fastCliques.size() ? 1 : 0) != 0);
            i = 0;
            while (i < slowCliques.size()) {
                Clique slow = slowCliques.get(i);
                Clique fast = fastCliques.get(i);
                TestDenseSubgraphs.assertTrue((boolean)slow.getIndices().containsAll(fast.getIndices()));
                TestDenseSubgraphs.assertTrue((boolean)fast.getIndices().containsAll(slow.getIndices()));
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

