/*
 * Decompiled with CFR 0.152.
 */
package test;

import edu.umd.coral.model.data.BitSymmetricMatrix;
import junit.framework.TestCase;

public class TestBitMatrix
extends TestCase {
    public void testPrint() {
        System.out.println(BitSymmetricMatrix.printBits(1L));
        System.out.println(BitSymmetricMatrix.printBits(4L));
        System.out.println(BitSymmetricMatrix.printBits(7L));
    }

    public void testCreate() {
        try {
            BitSymmetricMatrix bsm = new BitSymmetricMatrix(7, new String[7]);
            TestBitMatrix.assertTrue((bsm.getVectorCount() == 1 ? 1 : 0) != 0);
            bsm = new BitSymmetricMatrix(8, new String[8]);
            double maxVectors = 0.5079365079365079;
            TestBitMatrix.assertTrue((bsm.getVectorCount() == (int)Math.ceil(maxVectors) ? 1 : 0) != 0);
            bsm = new BitSymmetricMatrix(12, new String[12]);
            maxVectors = 1.1428571428571428;
            TestBitMatrix.assertTrue((bsm.getVectorCount() == (int)Math.ceil(maxVectors) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            TestBitMatrix.assertTrue((boolean)false);
        }
    }

    public void testGetElement() {
        try {
            BitSymmetricMatrix bsm = new BitSymmetricMatrix(12, new String[12]);
            int i = 0;
            while (i < 12) {
                int j = 0;
                while (j < 12) {
                    TestBitMatrix.assertTrue((bsm.getElement(i, j) == 0.0 ? 1 : 0) != 0);
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetSetElement() {
        try {
            int j;
            BitSymmetricMatrix bsm = new BitSymmetricMatrix(12, new String[12]);
            double maxVectors = 1.1428571428571428;
            TestBitMatrix.assertTrue((bsm.getVectorCount() == (int)Math.ceil(maxVectors) ? 1 : 0) != 0);
            bsm.setElement(0, 0, 1, false);
            TestBitMatrix.assertTrue((bsm.getElement(0, 0) == 1.0 ? 1 : 0) != 0);
            int i = 0;
            while (i < 12) {
                j = 0;
                while (j < 12) {
                    if (i != 0 || j != 0) {
                        TestBitMatrix.assertTrue((bsm.getElement(i, j) == 0.0 ? 1 : 0) != 0);
                    }
                    ++j;
                }
                ++i;
            }
            bsm.setElement(9, 9, 1, false);
            TestBitMatrix.assertTrue((bsm.getElement(9, 9) == 1.0 ? 1 : 0) != 0);
            i = 0;
            while (i < 12) {
                j = 0;
                while (j < 12) {
                    if (!(i == 0 && j == 0 || i == 9 && j == 9)) {
                        TestBitMatrix.assertTrue((bsm.getElement(i, j) == 0.0 ? 1 : 0) != 0);
                    }
                    ++j;
                }
                ++i;
            }
            bsm.setElement(0, 0, 0, false);
            TestBitMatrix.assertTrue((bsm.getElement(0, 0) == 0.0 ? 1 : 0) != 0);
            i = 0;
            while (i < 12) {
                j = 0;
                while (j < 12) {
                    if (i != 9 || j != 9) {
                        TestBitMatrix.assertTrue((bsm.getElement(i, j) == 0.0 ? 1 : 0) != 0);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestBitMatrix.assertTrue((boolean)false);
        }
    }

    public void testSymmetric() {
        BitSymmetricMatrix bsm = new BitSymmetricMatrix(12, new String[12]);
        bsm.setElement(3, 4, 1, false);
        TestBitMatrix.assertTrue((bsm.getElement(3, 4) == 1.0 ? 1 : 0) != 0);
        TestBitMatrix.assertTrue((bsm.getElement(4, 3) == 1.0 ? 1 : 0) != 0);
        bsm.setElement(5, 4, 1, false);
        TestBitMatrix.assertTrue((bsm.getElement(5, 4) == 1.0 ? 1 : 0) != 0);
        TestBitMatrix.assertTrue((bsm.getElement(4, 5) == 1.0 ? 1 : 0) != 0);
        bsm.setElement(4, 3, 0, false);
        TestBitMatrix.assertTrue((bsm.getElement(3, 4) == 0.0 ? 1 : 0) != 0);
        TestBitMatrix.assertTrue((bsm.getElement(4, 3) == 0.0 ? 1 : 0) != 0);
        bsm.setElement(4, 5, 0, false);
        TestBitMatrix.assertTrue((bsm.getElement(5, 4) == 0.0 ? 1 : 0) != 0);
        TestBitMatrix.assertTrue((bsm.getElement(4, 5) == 0.0 ? 1 : 0) != 0);
    }

    public void testRandomAccess() {
        int N = 10;
        BitSymmetricMatrix bsm = new BitSymmetricMatrix(N, new String[N]);
        System.out.println("Vectors: " + bsm.getVectorCount());
        int i = 0;
        while (i < N) {
            int j = i;
            while (j < N) {
                bsm.setElement(i, j, 1, false);
                ++j;
            }
            ++i;
        }
        int k = 0;
        while (k < 10000) {
            int r = (int)Math.round(Math.random() * (double)(N - 1));
            int c = (int)Math.round(Math.random() * (double)(N - 1));
            TestBitMatrix.assertEquals((double)bsm.getElement(r, c), (double)1.0, (double)1.0E-5);
            ++k;
        }
    }

    public void testGetJaccard() {
        BitSymmetricMatrix m1 = new BitSymmetricMatrix(5, new String[5]);
        BitSymmetricMatrix m2 = new BitSymmetricMatrix(5, new String[5]);
        m1.setElement(0, 1, 1, false);
        m1.setElement(2, 3, 1, false);
        m1.setElement(2, 4, 1, false);
        m1.setElement(3, 4, 1, false);
        m1.setElement(4, 4, 1, false);
        m2.setElement(0, 1, 1, false);
        m2.setElement(2, 3, 1, false);
        m2.setElement(2, 4, 1, false);
        m2.setElement(3, 4, 1, false);
        TestBitMatrix.assertTrue((BitSymmetricMatrix.jaccard(m1, m2, false) == 1.0f ? 1 : 0) != 0);
        m2.setElement(0, 1, 0, false);
        int inter = 3;
        int union = 4;
        TestBitMatrix.assertTrue(((double)BitSymmetricMatrix.jaccard(m1, m2, false) == (double)inter * 1.0 / (double)union ? 1 : 0) != 0);
    }
}

